<?php
/**
* Custom Addons.
*
* @package Responsive Landing Page
*/

$wp_customize->add_section( 'responsive_landing_page_theme_pagination_options',
    array(
    'title'      => esc_html__( 'Customizer Custom Settings', 'responsive-landing-page' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'responsive_landing_page_theme_addons_panel',
    )
);

$wp_customize->add_setting('responsive_landing_page_theme_loader',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_theme_loader'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_theme_loader',
    array(
        'label' => esc_html__('Enable Preloader', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_theme_pagination_options',
        'type' => 'checkbox',
    )
);

// Add Pagination Enable/Disable option to Customizer
$wp_customize->add_setting( 'responsive_landing_page_enable_pagination', 
    array(
        'default'           => true, // Default is enabled
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_enable_pagination', // Sanitize the input
    )
);

// Add the control to the Customizer
$wp_customize->add_control( 'responsive_landing_page_enable_pagination', 
    array(
        'label'    => esc_html__( 'Enable Pagination', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_theme_pagination_options', // Add to the correct section
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_theme_pagination_type', 
    array(
        'default'           => 'numeric', // Set "numeric" as the default
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_pagination_type', // Use our sanitize function
    )
);

$wp_customize->add_control( 'responsive_landing_page_theme_pagination_type',
    array(
        'label'       => esc_html__( 'Pagination Style', 'responsive-landing-page' ),
        'section'     => 'responsive_landing_page_theme_pagination_options',
        'type'        => 'select',
        'choices'     => array(
            'numeric'      => esc_html__( 'Numeric (Page Numbers)', 'responsive-landing-page' ),
            'newer_older'  => esc_html__( 'Newer/Older (Previous/Next)', 'responsive-landing-page' ), // Renamed to "Newer/Older"
        ),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_theme_pagination_options_alignment',
    array(
    'default' => $responsive_landing_page_default['responsive_landing_page_theme_pagination_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'responsive_landing_page_theme_pagination_options_alignment',
    array(
    'label'       => esc_html__( 'Pagination Alignment', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'responsive-landing-page' ),
        'Right' => esc_html__( 'Right', 'responsive-landing-page' ),
        'Left'  => esc_html__( 'Left', 'responsive-landing-page' ),
        ),
    )
);

$wp_customize->add_setting('responsive_landing_page_theme_breadcrumb_enable',
array(
    'default' => $responsive_landing_page_default['responsive_landing_page_theme_breadcrumb_enable'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
)
);
$wp_customize->add_control('responsive_landing_page_theme_breadcrumb_enable',
    array(
        'label' => esc_html__('Enable Breadcrumb', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_theme_pagination_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_theme_breadcrumb_options_alignment',
    array(
    'default' => $responsive_landing_page_default['responsive_landing_page_theme_breadcrumb_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'responsive_landing_page_theme_breadcrumb_options_alignment',
    array(
    'label'       => esc_html__( 'Breadcrumb Alignment', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'responsive-landing-page' ),
        'Right' => esc_html__( 'Right', 'responsive-landing-page' ),
        'Left'  => esc_html__( 'Left', 'responsive-landing-page' ),
        ),
    )
);

$wp_customize->add_setting('responsive_landing_page_breadcrumb_font_size',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_breadcrumb_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
    )
);
$wp_customize->add_control('responsive_landing_page_breadcrumb_font_size',
    array(
        'label'       => esc_html__('Breadcrumb Font Size', 'responsive-landing-page'),
        'section'     => 'responsive_landing_page_theme_pagination_options',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 45,
           'step'   => 1,
        ),
    )
);