<?php
/**
* Additional Woocommerce Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'responsive_landing_page_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'responsive-landing-page' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

	$wp_customize->add_setting('responsive_landing_page_per_columns',
		array(
		'default'           => $responsive_landing_page_default['responsive_landing_page_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
		)
	);
	$wp_customize->add_control('responsive_landing_page_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'responsive-landing-page'),
		'section'     => 'responsive_landing_page_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('responsive_landing_page_product_per_page',
		array(
		'default'           => $responsive_landing_page_default['responsive_landing_page_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
		)
	);
	$wp_customize->add_control('responsive_landing_page_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'responsive-landing-page'),
		'section'     => 'responsive_landing_page_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('responsive_landing_page_show_hide_related_product',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('responsive_landing_page_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'responsive-landing-page'),
	        'section' => 'responsive_landing_page_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('responsive_landing_page_custom_related_products_number',
		array(
		'default'           => $responsive_landing_page_default['responsive_landing_page_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
		)
	);
	$wp_customize->add_control('responsive_landing_page_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'responsive-landing-page'),
		'section'     => 'responsive_landing_page_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('responsive_landing_page_custom_related_products_number_per_row',
		array(
		'default'           => $responsive_landing_page_default['responsive_landing_page_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
		)
	);
	$wp_customize->add_control('responsive_landing_page_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'responsive-landing-page'),
		'section'     => 'responsive_landing_page_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);