<?php
/**
* 404 Page Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

$wp_customize->add_section( 'responsive_landing_page_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'responsive-landing-page' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'responsive_landing_page_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_404_main_title',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_404_subtitle_one',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_404_para_one',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_404_subtitle_two',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_404_para_two',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'responsive-landing-page' ),
        'section'  => 'responsive_landing_page_404_page_settings',
        'type'     => 'text',
    )
);