<?php
/**
 * Body Classes.
 * @package Responsive Landing Page
 */

if (!function_exists('responsive_landing_page_body_classes')) :

    function responsive_landing_page_body_classes($responsive_landing_page_classes)
    {
        $responsive_landing_page_defaults = responsive_landing_page_get_default_theme_options();
        $responsive_landing_page_layout = responsive_landing_page_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $responsive_landing_page_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $responsive_landing_page_classes[] = $responsive_landing_page_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('responsive_landing_page_copyright_alignment', 'Default');
        $responsive_landing_page_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $responsive_landing_page_classes;
    }

endif;

add_filter('body_class', 'responsive_landing_page_body_classes');