<?php
/**
 * Functions for sending list of icon fonts available.
 *
 * @package hoot
 * @subpackage framework
 * @since hoot 1.0.0
 */

/**
 * Generates the icon and section list
 *
 * @since 1.0.0
 * @access public
 * @param string $return array to return sections|icons
 * @return array
 */
function hoot_fonticons_list( $return = 'icons' ) {

	if ( 'sections' == $return ) :
		return apply_filters( 'hoot_fonticons_sections', array(
			'fonticons' => __('Font Icons', 'responsive-brix'),
			'brands'    => __('Brands', 'responsive-brix'),
			)
		);
	endif;

	if ( 'icons' == $return ) :
		return apply_filters( 'hoot_fonticons_icons', array (

			'fonticons' => array (
				'fa-ad fas',
				'fa-address-book far',
				'fa-address-book fas',
				'fa-address-card far',
				'fa-address-card fas',
				'fa-adjust fas',
				'fa-air-freshener fas',
				'fa-align-center fas',
				'fa-align-justify fas',
				'fa-align-left fas',
				'fa-align-right fas',
				'fa-allergies fas',
				'fa-ambulance fas',
				'fa-american-sign-language-interpreting fas',
				'fa-anchor fas',
				'fa-angle-double-down fas',
				'fa-angle-double-left fas',
				'fa-angle-double-right fas',
				'fa-angle-double-up fas',
				'fa-angle-down fas',
				'fa-angle-left fas',
				'fa-angle-right fas',
				'fa-angle-up fas',
				'fa-angry far',
				'fa-angry fas',
				'fa-ankh fas',
				'fa-apple-alt fas',
				'fa-archive fas',
				'fa-archway fas',
				'fa-arrow-alt-circle-down far',
				'fa-arrow-alt-circle-down fas',
				'fa-arrow-alt-circle-left far',
				'fa-arrow-alt-circle-left fas',
				'fa-arrow-alt-circle-right far',
				'fa-arrow-alt-circle-right fas',
				'fa-arrow-alt-circle-up far',
				'fa-arrow-alt-circle-up fas',
				'fa-arrow-circle-down fas',
				'fa-arrow-circle-left fas',
				'fa-arrow-circle-right fas',
				'fa-arrow-circle-up fas',
				'fa-arrow-down fas',
				'fa-arrow-left fas',
				'fa-arrow-right fas',
				'fa-arrows-alt fas',
				'fa-arrows-alt-h fas',
				'fa-arrows-alt-v fas',
				'fa-arrow-up fas',
				'fa-assistive-listening-systems fas',
				'fa-asterisk fas',
				'fa-at fas',
				'fa-atlas fas',
				'fa-atom fas',
				'fa-audio-description fas',
				'fa-award fas',
				'fa-baby fas',
				'fa-baby-carriage fas',
				'fa-backspace fas',
				'fa-backward fas',
				'fa-bacon fas',
				'fa-bacteria fas',
				'fa-bacterium fas',
				'fa-bahai fas',
				'fa-balance-scale fas',
				'fa-balance-scale-left fas',
				'fa-balance-scale-right fas',
				'fa-ban fas',
				'fa-band-aid fas',
				'fa-barcode fas',
				'fa-bars fas',
				'fa-baseball-ball fas',
				'fa-basketball-ball fas',
				'fa-bath fas',
				'fa-battery-empty fas',
				'fa-battery-full fas',
				'fa-battery-half fas',
				'fa-battery-quarter fas',
				'fa-battery-three-quarters fas',
				'fa-bed fas',
				'fa-beer fas',
				'fa-bell far',
				'fa-bell fas',
				'fa-bell-slash far',
				'fa-bell-slash fas',
				'fa-bezier-curve fas',
				'fa-bible fas',
				'fa-bicycle fas',
				'fa-biking fas',
				'fa-binoculars fas',
				'fa-biohazard fas',
				'fa-birthday-cake fas',
				'fa-blender fas',
				'fa-blender-phone fas',
				'fa-blind fas',
				'fa-blog fas',
				'fa-bold fas',
				'fa-bolt fas',
				'fa-bomb fas',
				'fa-bone fas',
				'fa-bong fas',
				'fa-book fas',
				'fa-book-dead fas',
				'fa-bookmark far',
				'fa-bookmark fas',
				'fa-book-medical fas',
				'fa-book-open fas',
				'fa-book-reader fas',
				'fa-border-all fas',
				'fa-border-none fas',
				'fa-border-style fas',
				'fa-bowling-ball fas',
				'fa-box fas',
				'fa-boxes fas',
				'fa-box-open fas',
				'fa-box-tissue fas',
				'fa-braille fas',
				'fa-brain fas',
				'fa-bread-slice fas',
				'fa-briefcase fas',
				'fa-briefcase-medical fas',
				'fa-broadcast-tower fas',
				'fa-broom fas',
				'fa-brush fas',
				'fa-bug fas',
				'fa-building far',
				'fa-building fas',
				'fa-bullhorn fas',
				'fa-bullseye fas',
				'fa-burn fas',
				'fa-bus fas',
				'fa-bus-alt fas',
				'fa-business-time fas',
				'fa-calculator fas',
				'fa-calendar far',
				'fa-calendar fas',
				'fa-calendar-alt far',
				'fa-calendar-alt fas',
				'fa-calendar-check far',
				'fa-calendar-check fas',
				'fa-calendar-day fas',
				'fa-calendar-minus far',
				'fa-calendar-minus fas',
				'fa-calendar-plus far',
				'fa-calendar-plus fas',
				'fa-calendar-times far',
				'fa-calendar-times fas',
				'fa-calendar-week fas',
				'fa-camera fas',
				'fa-camera-retro fas',
				'fa-campground fas',
				'fa-candy-cane fas',
				'fa-cannabis fas',
				'fa-capsules fas',
				'fa-car fas',
				'fa-car-alt fas',
				'fa-caravan fas',
				'fa-car-battery fas',
				'fa-car-crash fas',
				'fa-caret-down fas',
				'fa-caret-left fas',
				'fa-caret-right fas',
				'fa-caret-square-down far',
				'fa-caret-square-down fas',
				'fa-caret-square-left far',
				'fa-caret-square-left fas',
				'fa-caret-square-right far',
				'fa-caret-square-right fas',
				'fa-caret-square-up far',
				'fa-caret-square-up fas',
				'fa-caret-up fas',
				'fa-carrot fas',
				'fa-car-side fas',
				'fa-cart-arrow-down fas',
				'fa-cart-plus fas',
				'fa-cash-register fas',
				'fa-cat fas',
				'fa-certificate fas',
				'fa-chair fas',
				'fa-chalkboard fas',
				'fa-chalkboard-teacher fas',
				'fa-charging-station fas',
				'fa-chart-area fas',
				'fa-chart-bar far',
				'fa-chart-bar fas',
				'fa-chart-line fas',
				'fa-chart-pie fas',
				'fa-check fas',
				'fa-check-circle far',
				'fa-check-circle fas',
				'fa-check-double fas',
				'fa-check-square far',
				'fa-check-square fas',
				'fa-cheese fas',
				'fa-chess fas',
				'fa-chess-bishop fas',
				'fa-chess-board fas',
				'fa-chess-king fas',
				'fa-chess-knight fas',
				'fa-chess-pawn fas',
				'fa-chess-queen fas',
				'fa-chess-rook fas',
				'fa-chevron-circle-down fas',
				'fa-chevron-circle-left fas',
				'fa-chevron-circle-right fas',
				'fa-chevron-circle-up fas',
				'fa-chevron-down fas',
				'fa-chevron-left fas',
				'fa-chevron-right fas',
				'fa-chevron-up fas',
				'fa-child fas',
				'fa-church fas',
				'fa-circle far',
				'fa-circle fas',
				'fa-circle-notch fas',
				'fa-city fas',
				'fa-clinic-medical fas',
				'fa-clipboard far',
				'fa-clipboard fas',
				'fa-clipboard-check fas',
				'fa-clipboard-list fas',
				'fa-clock far',
				'fa-clock fas',
				'fa-clone far',
				'fa-clone fas',
				'fa-closed-captioning far',
				'fa-closed-captioning fas',
				'fa-cloud fas',
				'fa-cloud-download-alt fas',
				'fa-cloud-meatball fas',
				'fa-cloud-moon fas',
				'fa-cloud-moon-rain fas',
				'fa-cloud-rain fas',
				'fa-cloud-showers-heavy fas',
				'fa-cloud-sun fas',
				'fa-cloud-sun-rain fas',
				'fa-cloud-upload-alt fas',
				'fa-cocktail fas',
				'fa-code fas',
				'fa-code-branch fas',
				'fa-coffee fas',
				'fa-cog fas',
				'fa-cogs fas',
				'fa-coins fas',
				'fa-columns fas',
				'fa-comment far',
				'fa-comment fas',
				'fa-comment-alt far',
				'fa-comment-alt fas',
				'fa-comment-dollar fas',
				'fa-comment-dots far',
				'fa-comment-dots fas',
				'fa-comment-medical fas',
				'fa-comments far',
				'fa-comments fas',
				'fa-comments-dollar fas',
				'fa-comment-slash fas',
				'fa-compact-disc fas',
				'fa-compass far',
				'fa-compass fas',
				'fa-compress fas',
				'fa-compress-alt fas',
				'fa-compress-arrows-alt fas',
				'fa-concierge-bell fas',
				'fa-cookie fas',
				'fa-cookie-bite fas',
				'fa-copy far',
				'fa-copy fas',
				'fa-copyright far',
				'fa-copyright fas',
				'fa-couch fas',
				'fa-credit-card far',
				'fa-credit-card fas',
				'fa-crop fas',
				'fa-crop-alt fas',
				'fa-cross fas',
				'fa-crosshairs fas',
				'fa-crow fas',
				'fa-crown fas',
				'fa-crutch fas',
				'fa-cube fas',
				'fa-cubes fas',
				'fa-cut fas',
				'fa-database fas',
				'fa-deaf fas',
				'fa-democrat fas',
				'fa-desktop fas',
				'fa-dharmachakra fas',
				'fa-diagnoses fas',
				'fa-dice fas',
				'fa-dice-d20 fas',
				'fa-dice-d6 fas',
				'fa-dice-five fas',
				'fa-dice-four fas',
				'fa-dice-one fas',
				'fa-dice-six fas',
				'fa-dice-three fas',
				'fa-dice-two fas',
				'fa-digital-tachograph fas',
				'fa-directions fas',
				'fa-disease fas',
				'fa-divide fas',
				'fa-dizzy far',
				'fa-dizzy fas',
				'fa-dna fas',
				'fa-dog fas',
				'fa-dollar-sign fas',
				'fa-dolly fas',
				'fa-dolly-flatbed fas',
				'fa-donate fas',
				'fa-door-closed fas',
				'fa-door-open fas',
				'fa-dot-circle far',
				'fa-dot-circle fas',
				'fa-dove fas',
				'fa-download fas',
				'fa-drafting-compass fas',
				'fa-dragon fas',
				'fa-draw-polygon fas',
				'fa-drum fas',
				'fa-drum-steelpan fas',
				'fa-drumstick-bite fas',
				'fa-dumbbell fas',
				'fa-dumpster fas',
				'fa-dumpster-fire fas',
				'fa-dungeon fas',
				'fa-edit far',
				'fa-edit fas',
				'fa-egg fas',
				'fa-eject fas',
				'fa-ellipsis-h fas',
				'fa-ellipsis-v fas',
				'fa-envelope far',
				'fa-envelope fas',
				'fa-envelope-open far',
				'fa-envelope-open fas',
				'fa-envelope-open-text fas',
				'fa-envelope-square fas',
				'fa-equals fas',
				'fa-eraser fas',
				'fa-ethernet fas',
				'fa-euro-sign fas',
				'fa-exchange-alt fas',
				'fa-exclamation fas',
				'fa-exclamation-circle fas',
				'fa-exclamation-triangle fas',
				'fa-expand fas',
				'fa-expand-alt fas',
				'fa-expand-arrows-alt fas',
				'fa-external-link-alt fas',
				'fa-external-link-square-alt fas',
				'fa-eye far',
				'fa-eye fas',
				'fa-eye-dropper fas',
				'fa-eye-slash far',
				'fa-eye-slash fas',
				'fa-fan fas',
				'fa-fast-backward fas',
				'fa-fast-forward fas',
				'fa-faucet fas',
				'fa-fax fas',
				'fa-feather fas',
				'fa-feather-alt fas',
				'fa-female fas',
				'fa-fighter-jet fas',
				'fa-file far',
				'fa-file fas',
				'fa-file-alt far',
				'fa-file-alt fas',
				'fa-file-archive far',
				'fa-file-archive fas',
				'fa-file-audio far',
				'fa-file-audio fas',
				'fa-file-code far',
				'fa-file-code fas',
				'fa-file-contract fas',
				'fa-file-csv fas',
				'fa-file-download fas',
				'fa-file-excel far',
				'fa-file-excel fas',
				'fa-file-export fas',
				'fa-file-image far',
				'fa-file-image fas',
				'fa-file-import fas',
				'fa-file-invoice fas',
				'fa-file-invoice-dollar fas',
				'fa-file-medical fas',
				'fa-file-medical-alt fas',
				'fa-file-pdf far',
				'fa-file-pdf fas',
				'fa-file-powerpoint far',
				'fa-file-powerpoint fas',
				'fa-file-prescription fas',
				'fa-file-signature fas',
				'fa-file-upload fas',
				'fa-file-video far',
				'fa-file-video fas',
				'fa-file-word far',
				'fa-file-word fas',
				'fa-fill fas',
				'fa-fill-drip fas',
				'fa-film fas',
				'fa-filter fas',
				'fa-fingerprint fas',
				'fa-fire fas',
				'fa-fire-alt fas',
				'fa-fire-extinguisher fas',
				'fa-first-aid fas',
				'fa-fish fas',
				'fa-fist-raised fas',
				'fa-flag far',
				'fa-flag fas',
				'fa-flag-checkered fas',
				'fa-flag-usa fas',
				'fa-flask fas',
				'fa-flushed far',
				'fa-flushed fas',
				'fa-folder far',
				'fa-folder fas',
				'fa-folder-minus fas',
				'fa-folder-open far',
				'fa-folder-open fas',
				'fa-folder-plus fas',
				'fa-font fas',
				'fa-football-ball fas',
				'fa-forward fas',
				'fa-frog fas',
				'fa-frown far',
				'fa-frown fas',
				'fa-frown-open far',
				'fa-frown-open fas',
				'fa-funnel-dollar fas',
				'fa-futbol far',
				'fa-futbol fas',
				'fa-gamepad fas',
				'fa-gas-pump fas',
				'fa-gavel fas',
				'fa-gem far',
				'fa-gem fas',
				'fa-genderless fas',
				'fa-ghost fas',
				'fa-gift fas',
				'fa-gifts fas',
				'fa-glass-cheers fas',
				'fa-glasses fas',
				'fa-glass-martini fas',
				'fa-glass-martini-alt fas',
				'fa-glass-whiskey fas',
				'fa-globe fas',
				'fa-globe-africa fas',
				'fa-globe-americas fas',
				'fa-globe-asia fas',
				'fa-globe-europe fas',
				'fa-golf-ball fas',
				'fa-gopuram fas',
				'fa-graduation-cap fas',
				'fa-greater-than fas',
				'fa-greater-than-equal fas',
				'fa-grimace far',
				'fa-grimace fas',
				'fa-grin far',
				'fa-grin fas',
				'fa-grin-alt far',
				'fa-grin-alt fas',
				'fa-grin-beam far',
				'fa-grin-beam fas',
				'fa-grin-beam-sweat far',
				'fa-grin-beam-sweat fas',
				'fa-grin-hearts far',
				'fa-grin-hearts fas',
				'fa-grin-squint far',
				'fa-grin-squint fas',
				'fa-grin-squint-tears far',
				'fa-grin-squint-tears fas',
				'fa-grin-stars far',
				'fa-grin-stars fas',
				'fa-grin-tears far',
				'fa-grin-tears fas',
				'fa-grin-tongue far',
				'fa-grin-tongue fas',
				'fa-grin-tongue-squint far',
				'fa-grin-tongue-squint fas',
				'fa-grin-tongue-wink far',
				'fa-grin-tongue-wink fas',
				'fa-grin-wink far',
				'fa-grin-wink fas',
				'fa-grip-horizontal fas',
				'fa-grip-lines fas',
				'fa-grip-lines-vertical fas',
				'fa-grip-vertical fas',
				'fa-guitar fas',
				'fa-hamburger fas',
				'fa-hammer fas',
				'fa-hamsa fas',
				'fa-hand-holding fas',
				'fa-hand-holding-heart fas',
				'fa-hand-holding-medical fas',
				'fa-hand-holding-usd fas',
				'fa-hand-holding-water fas',
				'fa-hand-lizard far',
				'fa-hand-lizard fas',
				'fa-hand-middle-finger fas',
				'fa-hand-paper far',
				'fa-hand-paper fas',
				'fa-hand-peace far',
				'fa-hand-peace fas',
				'fa-hand-point-down far',
				'fa-hand-point-down fas',
				'fa-hand-pointer far',
				'fa-hand-pointer fas',
				'fa-hand-point-left far',
				'fa-hand-point-left fas',
				'fa-hand-point-right far',
				'fa-hand-point-right fas',
				'fa-hand-point-up far',
				'fa-hand-point-up fas',
				'fa-hand-rock far',
				'fa-hand-rock fas',
				'fa-hands fas',
				'fa-hand-scissors far',
				'fa-hand-scissors fas',
				'fa-handshake far',
				'fa-handshake fas',
				'fa-handshake-alt-slash fas',
				'fa-handshake-slash fas',
				'fa-hands-helping fas',
				'fa-hand-sparkles fas',
				'fa-hand-spock far',
				'fa-hand-spock fas',
				'fa-hands-wash fas',
				'fa-hanukiah fas',
				'fa-hard-hat fas',
				'fa-hashtag fas',
				'fa-hat-cowboy fas',
				'fa-hat-cowboy-side fas',
				'fa-hat-wizard fas',
				'fa-hdd far',
				'fa-hdd fas',
				'fa-heading fas',
				'fa-headphones fas',
				'fa-headphones-alt fas',
				'fa-headset fas',
				'fa-head-side-cough fas',
				'fa-head-side-cough-slash fas',
				'fa-head-side-mask fas',
				'fa-head-side-virus fas',
				'fa-heart far',
				'fa-heart fas',
				'fa-heartbeat fas',
				'fa-heart-broken fas',
				'fa-helicopter fas',
				'fa-highlighter fas',
				'fa-hiking fas',
				'fa-hippo fas',
				'fa-history fas',
				'fa-hockey-puck fas',
				'fa-holly-berry fas',
				'fa-home fas',
				'fa-horse fas',
				'fa-horse-head fas',
				'fa-hospital far',
				'fa-hospital fas',
				'fa-hospital-alt fas',
				'fa-hospital-symbol fas',
				'fa-hospital-user fas',
				'fa-hotdog fas',
				'fa-hotel fas',
				'fa-hot-tub fas',
				'fa-hourglass far',
				'fa-hourglass fas',
				'fa-hourglass-end fas',
				'fa-hourglass-half fas',
				'fa-hourglass-start fas',
				'fa-house-damage fas',
				'fa-house-user fas',
				'fa-hryvnia fas',
				'fa-h-square fas',
				'fa-ice-cream fas',
				'fa-icicles fas',
				'fa-icons fas',
				'fa-i-cursor fas',
				'fa-id-badge far',
				'fa-id-badge fas',
				'fa-id-card far',
				'fa-id-card fas',
				'fa-id-card-alt fas',
				'fa-igloo fas',
				'fa-image far',
				'fa-image fas',
				'fa-images far',
				'fa-images fas',
				'fa-inbox fas',
				'fa-indent fas',
				'fa-industry fas',
				'fa-infinity fas',
				'fa-info fas',
				'fa-info-circle fas',
				'fa-italic fas',
				'fa-jedi fas',
				'fa-joint fas',
				'fa-journal-whills fas',
				'fa-kaaba fas',
				'fa-key fas',
				'fa-keyboard far',
				'fa-keyboard fas',
				'fa-khanda fas',
				'fa-kiss far',
				'fa-kiss fas',
				'fa-kiss-beam far',
				'fa-kiss-beam fas',
				'fa-kiss-wink-heart far',
				'fa-kiss-wink-heart fas',
				'fa-kiwi-bird fas',
				'fa-landmark fas',
				'fa-language fas',
				'fa-laptop fas',
				'fa-laptop-code fas',
				'fa-laptop-house fas',
				'fa-laptop-medical fas',
				'fa-laugh far',
				'fa-laugh fas',
				'fa-laugh-beam far',
				'fa-laugh-beam fas',
				'fa-laugh-squint far',
				'fa-laugh-squint fas',
				'fa-laugh-wink far',
				'fa-laugh-wink fas',
				'fa-layer-group fas',
				'fa-leaf fas',
				'fa-lemon far',
				'fa-lemon fas',
				'fa-less-than fas',
				'fa-less-than-equal fas',
				'fa-level-down-alt fas',
				'fa-level-up-alt fas',
				'fa-life-ring far',
				'fa-life-ring fas',
				'fa-lightbulb far',
				'fa-lightbulb fas',
				'fa-link fas',
				'fa-lira-sign fas',
				'fa-list fas',
				'fa-list-alt far',
				'fa-list-alt fas',
				'fa-list-ol fas',
				'fa-list-ul fas',
				'fa-location-arrow fas',
				'fa-lock fas',
				'fa-lock-open fas',
				'fa-long-arrow-alt-down fas',
				'fa-long-arrow-alt-left fas',
				'fa-long-arrow-alt-right fas',
				'fa-long-arrow-alt-up fas',
				'fa-low-vision fas',
				'fa-luggage-cart fas',
				'fa-lungs fas',
				'fa-lungs-virus fas',
				'fa-magic fas',
				'fa-magnet fas',
				'fa-mail-bulk fas',
				'fa-male fas',
				'fa-map far',
				'fa-map fas',
				'fa-map-marked fas',
				'fa-map-marked-alt fas',
				'fa-map-marker fas',
				'fa-map-marker-alt fas',
				'fa-map-pin fas',
				'fa-map-signs fas',
				'fa-marker fas',
				'fa-mars fas',
				'fa-mars-double fas',
				'fa-mars-stroke fas',
				'fa-mars-stroke-h fas',
				'fa-mars-stroke-v fas',
				'fa-mask fas',
				'fa-medal fas',
				'fa-medkit fas',
				'fa-meh far',
				'fa-meh fas',
				'fa-meh-blank far',
				'fa-meh-blank fas',
				'fa-meh-rolling-eyes far',
				'fa-meh-rolling-eyes fas',
				'fa-memory fas',
				'fa-menorah fas',
				'fa-mercury fas',
				'fa-meteor fas',
				'fa-microchip fas',
				'fa-microphone fas',
				'fa-microphone-alt fas',
				'fa-microphone-alt-slash fas',
				'fa-microphone-slash fas',
				'fa-microscope fas',
				'fa-minus fas',
				'fa-minus-circle fas',
				'fa-minus-square far',
				'fa-minus-square fas',
				'fa-mitten fas',
				'fa-mobile fas',
				'fa-mobile-alt fas',
				'fa-money-bill fas',
				'fa-money-bill-alt far',
				'fa-money-bill-alt fas',
				'fa-money-bill-wave fas',
				'fa-money-bill-wave-alt fas',
				'fa-money-check fas',
				'fa-money-check-alt fas',
				'fa-monument fas',
				'fa-moon far',
				'fa-moon fas',
				'fa-mortar-pestle fas',
				'fa-mosque fas',
				'fa-motorcycle fas',
				'fa-mountain fas',
				'fa-mouse fas',
				'fa-mouse-pointer fas',
				'fa-mug-hot fas',
				'fa-music fas',
				'fa-network-wired fas',
				'fa-neuter fas',
				'fa-newspaper far',
				'fa-newspaper fas',
				'fa-not-equal fas',
				'fa-notes-medical fas',
				'fa-object-group far',
				'fa-object-group fas',
				'fa-object-ungroup far',
				'fa-object-ungroup fas',
				'fa-oil-can fas',
				'fa-om fas',
				'fa-otter fas',
				'fa-outdent fas',
				'fa-pager fas',
				'fa-paint-brush fas',
				'fa-paint-roller fas',
				'fa-palette fas',
				'fa-pallet fas',
				'fa-paperclip fas',
				'fa-paper-plane far',
				'fa-paper-plane fas',
				'fa-parachute-box fas',
				'fa-paragraph fas',
				'fa-parking fas',
				'fa-passport fas',
				'fa-pastafarianism fas',
				'fa-paste fas',
				'fa-pause fas',
				'fa-pause-circle far',
				'fa-pause-circle fas',
				'fa-paw fas',
				'fa-peace fas',
				'fa-pen fas',
				'fa-pen-alt fas',
				'fa-pencil-alt fas',
				'fa-pencil-ruler fas',
				'fa-pen-fancy fas',
				'fa-pen-nib fas',
				'fa-pen-square fas',
				'fa-people-arrows fas',
				'fa-people-carry fas',
				'fa-pepper-hot fas',
				'fa-percent fas',
				'fa-percentage fas',
				'fa-person-booth fas',
				'fa-phone fas',
				'fa-phone-alt fas',
				'fa-phone-slash fas',
				'fa-phone-square fas',
				'fa-phone-square-alt fas',
				'fa-phone-volume fas',
				'fa-photo-video fas',
				'fa-piggy-bank fas',
				'fa-pills fas',
				'fa-pizza-slice fas',
				'fa-place-of-worship fas',
				'fa-plane fas',
				'fa-plane-arrival fas',
				'fa-plane-departure fas',
				'fa-plane-slash fas',
				'fa-play fas',
				'fa-play-circle far',
				'fa-play-circle fas',
				'fa-plug fas',
				'fa-plus fas',
				'fa-plus-circle fas',
				'fa-plus-square far',
				'fa-plus-square fas',
				'fa-podcast fas',
				'fa-poll fas',
				'fa-poll-h fas',
				'fa-poo fas',
				'fa-poop fas',
				'fa-poo-storm fas',
				'fa-portrait fas',
				'fa-pound-sign fas',
				'fa-power-off fas',
				'fa-pray fas',
				'fa-praying-hands fas',
				'fa-prescription fas',
				'fa-prescription-bottle fas',
				'fa-prescription-bottle-alt fas',
				'fa-print fas',
				'fa-procedures fas',
				'fa-project-diagram fas',
				'fa-pump-medical fas',
				'fa-pump-soap fas',
				'fa-puzzle-piece fas',
				'fa-qrcode fas',
				'fa-question fas',
				'fa-question-circle far',
				'fa-question-circle fas',
				'fa-quidditch fas',
				'fa-quote-left fas',
				'fa-quote-right fas',
				'fa-quran fas',
				'fa-radiation fas',
				'fa-radiation-alt fas',
				'fa-rainbow fas',
				'fa-random fas',
				'fa-receipt fas',
				'fa-record-vinyl fas',
				'fa-recycle fas',
				'fa-redo fas',
				'fa-redo-alt fas',
				'fa-registered far',
				'fa-registered fas',
				'fa-remove-format fas',
				'fa-reply fas',
				'fa-reply-all fas',
				'fa-republican fas',
				'fa-restroom fas',
				'fa-retweet fas',
				'fa-ribbon fas',
				'fa-ring fas',
				'fa-road fas',
				'fa-robot fas',
				'fa-rocket fas',
				'fa-route fas',
				'fa-rss fas',
				'fa-rss-square fas',
				'fa-ruble-sign fas',
				'fa-ruler fas',
				'fa-ruler-combined fas',
				'fa-ruler-horizontal fas',
				'fa-ruler-vertical fas',
				'fa-running fas',
				'fa-rupee-sign fas',
				'fa-sad-cry far',
				'fa-sad-cry fas',
				'fa-sad-tear far',
				'fa-sad-tear fas',
				'fa-satellite fas',
				'fa-satellite-dish fas',
				'fa-save far',
				'fa-save fas',
				'fa-school fas',
				'fa-screwdriver fas',
				'fa-scroll fas',
				'fa-sd-card fas',
				'fa-search fas',
				'fa-search-dollar fas',
				'fa-search-location fas',
				'fa-search-minus fas',
				'fa-search-plus fas',
				'fa-seedling fas',
				'fa-server fas',
				'fa-shapes fas',
				'fa-share fas',
				'fa-share-alt fas',
				'fa-share-alt-square fas',
				'fa-share-square far',
				'fa-share-square fas',
				'fa-shekel-sign fas',
				'fa-shield-alt fas',
				'fa-shield-virus fas',
				'fa-ship fas',
				'fa-shipping-fast fas',
				'fa-shoe-prints fas',
				'fa-shopping-bag fas',
				'fa-shopping-basket fas',
				'fa-shopping-cart fas',
				'fa-shower fas',
				'fa-shuttle-van fas',
				'fa-sign fas',
				'fa-signal fas',
				'fa-signature fas',
				'fa-sign-in-alt fas',
				'fa-sign-language fas',
				'fa-sign-out-alt fas',
				'fa-sim-card fas',
				'fa-sink fas',
				'fa-sitemap fas',
				'fa-skating fas',
				'fa-skiing fas',
				'fa-skiing-nordic fas',
				'fa-skull fas',
				'fa-skull-crossbones fas',
				'fa-slash fas',
				'fa-sleigh fas',
				'fa-sliders-h fas',
				'fa-smile far',
				'fa-smile fas',
				'fa-smile-beam far',
				'fa-smile-beam fas',
				'fa-smile-wink far',
				'fa-smile-wink fas',
				'fa-smog fas',
				'fa-smoking fas',
				'fa-smoking-ban fas',
				'fa-sms fas',
				'fa-snowboarding fas',
				'fa-snowflake far',
				'fa-snowflake fas',
				'fa-snowman fas',
				'fa-snowplow fas',
				'fa-soap fas',
				'fa-socks fas',
				'fa-solar-panel fas',
				'fa-sort fas',
				'fa-sort-alpha-down fas',
				'fa-sort-alpha-down-alt fas',
				'fa-sort-alpha-up fas',
				'fa-sort-alpha-up-alt fas',
				'fa-sort-amount-down fas',
				'fa-sort-amount-down-alt fas',
				'fa-sort-amount-up fas',
				'fa-sort-amount-up-alt fas',
				'fa-sort-down fas',
				'fa-sort-numeric-down fas',
				'fa-sort-numeric-down-alt fas',
				'fa-sort-numeric-up fas',
				'fa-sort-numeric-up-alt fas',
				'fa-sort-up fas',
				'fa-spa fas',
				'fa-space-shuttle fas',
				'fa-spell-check fas',
				'fa-spider fas',
				'fa-spinner fas',
				'fa-splotch fas',
				'fa-spray-can fas',
				'fa-square far',
				'fa-square fas',
				'fa-square-full fas',
				'fa-square-root-alt fas',
				'fa-stamp fas',
				'fa-star far',
				'fa-star fas',
				'fa-star-and-crescent fas',
				'fa-star-half far',
				'fa-star-half fas',
				'fa-star-half-alt fas',
				'fa-star-of-david fas',
				'fa-star-of-life fas',
				'fa-step-backward fas',
				'fa-step-forward fas',
				'fa-stethoscope fas',
				'fa-sticky-note far',
				'fa-sticky-note fas',
				'fa-stop fas',
				'fa-stop-circle far',
				'fa-stop-circle fas',
				'fa-stopwatch fas',
				'fa-stopwatch-20 fas',
				'fa-store fas',
				'fa-store-alt fas',
				'fa-store-alt-slash fas',
				'fa-store-slash fas',
				'fa-stream fas',
				'fa-street-view fas',
				'fa-strikethrough fas',
				'fa-stroopwafel fas',
				'fa-subscript fas',
				'fa-subway fas',
				'fa-suitcase fas',
				'fa-suitcase-rolling fas',
				'fa-sun far',
				'fa-sun fas',
				'fa-superscript fas',
				'fa-surprise far',
				'fa-surprise fas',
				'fa-swatchbook fas',
				'fa-swimmer fas',
				'fa-swimming-pool fas',
				'fa-synagogue fas',
				'fa-sync fas',
				'fa-sync-alt fas',
				'fa-syringe fas',
				'fa-table fas',
				'fa-tablet fas',
				'fa-tablet-alt fas',
				'fa-table-tennis fas',
				'fa-tablets fas',
				'fa-tachometer-alt fas',
				'fa-tag fas',
				'fa-tags fas',
				'fa-tape fas',
				'fa-tasks fas',
				'fa-taxi fas',
				'fa-teeth fas',
				'fa-teeth-open fas',
				'fa-temperature-high fas',
				'fa-temperature-low fas',
				'fa-tenge fas',
				'fa-terminal fas',
				'fa-text-height fas',
				'fa-text-width fas',
				'fa-th fas',
				'fa-theater-masks fas',
				'fa-thermometer fas',
				'fa-thermometer-empty fas',
				'fa-thermometer-full fas',
				'fa-thermometer-half fas',
				'fa-thermometer-quarter fas',
				'fa-thermometer-three-quarters fas',
				'fa-th-large fas',
				'fa-th-list fas',
				'fa-thumbs-down far',
				'fa-thumbs-down fas',
				'fa-thumbs-up far',
				'fa-thumbs-up fas',
				'fa-thumbtack fas',
				'fa-ticket-alt fas',
				'fa-times fas',
				'fa-times-circle far',
				'fa-times-circle fas',
				'fa-tint fas',
				'fa-tint-slash fas',
				'fa-tired far',
				'fa-tired fas',
				'fa-toggle-off fas',
				'fa-toggle-on fas',
				'fa-toilet fas',
				'fa-toilet-paper fas',
				'fa-toilet-paper-slash fas',
				'fa-toolbox fas',
				'fa-tools fas',
				'fa-tooth fas',
				'fa-torah fas',
				'fa-torii-gate fas',
				'fa-tractor fas',
				'fa-trademark fas',
				'fa-traffic-light fas',
				'fa-trailer fas',
				'fa-train fas',
				'fa-tram fas',
				'fa-transgender fas',
				'fa-transgender-alt fas',
				'fa-trash fas',
				'fa-trash-alt far',
				'fa-trash-alt fas',
				'fa-trash-restore fas',
				'fa-trash-restore-alt fas',
				'fa-tree fas',
				'fa-trophy fas',
				'fa-truck fas',
				'fa-truck-loading fas',
				'fa-truck-monster fas',
				'fa-truck-moving fas',
				'fa-truck-pickup fas',
				'fa-tshirt fas',
				'fa-tty fas',
				'fa-tv fas',
				'fa-umbrella fas',
				'fa-umbrella-beach fas',
				'fa-underline fas',
				'fa-undo fas',
				'fa-undo-alt fas',
				'fa-universal-access fas',
				'fa-university fas',
				'fa-unlink fas',
				'fa-unlock fas',
				'fa-unlock-alt fas',
				'fa-upload fas',
				'fa-user far',
				'fa-user fas',
				'fa-user-alt fas',
				'fa-user-alt-slash fas',
				'fa-user-astronaut fas',
				'fa-user-check fas',
				'fa-user-circle far',
				'fa-user-circle fas',
				'fa-user-clock fas',
				'fa-user-cog fas',
				'fa-user-edit fas',
				'fa-user-friends fas',
				'fa-user-graduate fas',
				'fa-user-injured fas',
				'fa-user-lock fas',
				'fa-user-md fas',
				'fa-user-minus fas',
				'fa-user-ninja fas',
				'fa-user-nurse fas',
				'fa-user-plus fas',
				'fa-users fas',
				'fa-users-cog fas',
				'fa-user-secret fas',
				'fa-user-shield fas',
				'fa-user-slash fas',
				'fa-users-slash fas',
				'fa-user-tag fas',
				'fa-user-tie fas',
				'fa-user-times fas',
				'fa-utensils fas',
				'fa-utensil-spoon fas',
				'fa-vector-square fas',
				'fa-venus fas',
				'fa-venus-double fas',
				'fa-venus-mars fas',
				'fa-vest fas',
				'fa-vest-patches fas',
				'fa-vial fas',
				'fa-vials fas',
				'fa-video fas',
				'fa-video-slash fas',
				'fa-vihara fas',
				'fa-virus fas',
				'fa-viruses fas',
				'fa-virus-slash fas',
				'fa-voicemail fas',
				'fa-volleyball-ball fas',
				'fa-volume-down fas',
				'fa-volume-mute fas',
				'fa-volume-off fas',
				'fa-volume-up fas',
				'fa-vote-yea fas',
				'fa-vr-cardboard fas',
				'fa-walking fas',
				'fa-wallet fas',
				'fa-warehouse fas',
				'fa-water fas',
				'fa-wave-square fas',
				'fa-weight fas',
				'fa-weight-hanging fas',
				'fa-wheelchair fas',
				'fa-wifi fas',
				'fa-wind fas',
				'fa-window-close far',
				'fa-window-close fas',
				'fa-window-maximize far',
				'fa-window-maximize fas',
				'fa-window-minimize far',
				'fa-window-minimize fas',
				'fa-window-restore far',
				'fa-window-restore fas',
				'fa-wine-bottle fas',
				'fa-wine-glass fas',
				'fa-wine-glass-alt fas',
				'fa-won-sign fas',
				'fa-wrench fas',
				'fa-x-ray fas',
				'fa-yen-sign fas',
				'fa-yin-yang fas',
			),

			'brands' => array (
				'fa-500px fab',
				'fa-accessible-icon fab',
				'fa-accusoft fab',
				'fa-acquisitions-incorporated fab',
				'fa-adn fab',
				'fa-adversal fab',
				'fa-affiliatetheme fab',
				'fa-airbnb fab',
				'fa-algolia fab',
				'fa-alipay fab',
				'fa-amazon fab',
				'fa-amazon-pay fab',
				'fa-amilia fab',
				'fa-android fab',
				'fa-angellist fab',
				'fa-angrycreative fab',
				'fa-angular fab',
				'fa-app-store fab',
				'fa-app-store-ios fab',
				'fa-apper fab',
				'fa-apple fab',
				'fa-apple-pay fab',
				'fa-artstation fab',
				'fa-asymmetrik fab',
				'fa-atlassian fab',
				'fa-audible fab',
				'fa-autoprefixer fab',
				'fa-avianex fab',
				'fa-aviato fab',
				'fa-aws fab',
				'fa-bandcamp fab',
				'fa-battle-net fab',
				'fa-behance fab',
				'fa-behance-square fab',
				'fa-bimobject fab',
				'fa-bitbucket fab',
				'fa-bitcoin fab',
				'fa-bity fab',
				'fa-black-tie fab',
				'fa-blackberry fab',
				'fa-blogger fab',
				'fa-blogger-b fab',
				'fa-bluetooth fab',
				'fa-bluetooth-b fab',
				'fa-bootstrap fab',
				'fa-btc fab',
				'fa-buffer fab',
				'fa-buromobelexperte fab',
				'fa-buy-n-large fab',
				'fa-buysellads fab',
				'fa-canadian-maple-leaf fab',
				'fa-cc-amazon-pay fab',
				'fa-cc-amex fab',
				'fa-cc-apple-pay fab',
				'fa-cc-diners-club fab',
				'fa-cc-discover fab',
				'fa-cc-jcb fab',
				'fa-cc-mastercard fab',
				'fa-cc-paypal fab',
				'fa-cc-stripe fab',
				'fa-cc-visa fab',
				'fa-centercode fab',
				'fa-centos fab',
				'fa-chrome fab',
				'fa-chromecast fab',
				'fa-cloudflare fab',
				'fa-cloudscale fab',
				'fa-cloudsmith fab',
				'fa-cloudversify fab',
				'fa-codepen fab',
				'fa-codiepie fab',
				'fa-confluence fab',
				'fa-connectdevelop fab',
				'fa-contao fab',
				'fa-cotton-bureau fab',
				'fa-cpanel fab',
				'fa-creative-commons fab',
				'fa-creative-commons-by fab',
				'fa-creative-commons-nc fab',
				'fa-creative-commons-nc-eu fab',
				'fa-creative-commons-nc-jp fab',
				'fa-creative-commons-nd fab',
				'fa-creative-commons-pd fab',
				'fa-creative-commons-pd-alt fab',
				'fa-creative-commons-remix fab',
				'fa-creative-commons-sa fab',
				'fa-creative-commons-sampling fab',
				'fa-creative-commons-sampling-plus fab',
				'fa-creative-commons-share fab',
				'fa-creative-commons-zero fab',
				'fa-critical-role fab',
				'fa-css3 fab',
				'fa-css3-alt fab',
				'fa-cuttlefish fab',
				'fa-d-and-d fab',
				'fa-d-and-d-beyond fab',
				'fa-dailymotion fab',
				'fa-dashcube fab',
				'fa-deezer fab',
				'fa-delicious fab',
				'fa-deploydog fab',
				'fa-deskpro fab',
				'fa-dev fab',
				'fa-deviantart fab',
				'fa-dhl fab',
				'fa-diaspora fab',
				'fa-digg fab',
				'fa-digital-ocean fab',
				'fa-discord fab',
				'fa-discourse fab',
				'fa-dochub fab',
				'fa-docker fab',
				'fa-draft2digital fab',
				'fa-dribbble fab',
				'fa-dribbble-square fab',
				'fa-dropbox fab',
				'fa-drupal fab',
				'fa-dyalog fab',
				'fa-earlybirds fab',
				'fa-ebay fab',
				'fa-edge fab',
				'fa-edge-legacy fab',
				'fa-elementor fab',
				'fa-ello fab',
				'fa-ember fab',
				'fa-empire fab',
				'fa-envira fab',
				'fa-erlang fab',
				'fa-ethereum fab',
				'fa-etsy fab',
				'fa-evernote fab',
				'fa-expeditedssl fab',
				'fa-facebook fab',
				'fa-facebook-f fab',
				'fa-facebook-messenger fab',
				'fa-facebook-square fab',
				'fa-fantasy-flight-games fab',
				'fa-fedex fab',
				'fa-fedora fab',
				'fa-figma fab',
				'fa-firefox fab',
				'fa-firefox-browser fab',
				'fa-first-order fab',
				'fa-first-order-alt fab',
				'fa-firstdraft fab',
				'fa-flickr fab',
				'fa-flipboard fab',
				'fa-fly fab',
				'fa-font-awesome fab',
				'fa-font-awesome-alt fab',
				'fa-font-awesome-flag fab',
				'fa-fonticons fab',
				'fa-fonticons-fi fab',
				'fa-fort-awesome fab',
				'fa-fort-awesome-alt fab',
				'fa-forumbee fab',
				'fa-foursquare fab',
				'fa-free-code-camp fab',
				'fa-freebsd fab',
				'fa-fulcrum fab',
				'fa-galactic-republic fab',
				'fa-galactic-senate fab',
				'fa-get-pocket fab',
				'fa-gg fab',
				'fa-gg-circle fab',
				'fa-git fab',
				'fa-git-alt fab',
				'fa-git-square fab',
				'fa-github fab',
				'fa-github-alt fab',
				'fa-github-square fab',
				'fa-gitkraken fab',
				'fa-gitlab fab',
				'fa-gitter fab',
				'fa-glide fab',
				'fa-glide-g fab',
				'fa-gofore fab',
				'fa-goodreads fab',
				'fa-goodreads-g fab',
				'fa-google fab',
				'fa-google-drive fab',
				'fa-google-pay fab',
				'fa-google-play fab',
				'fa-google-plus fab',
				'fa-google-plus-g fab',
				'fa-google-plus-square fab',
				'fa-google-wallet fab',
				'fa-gratipay fab',
				'fa-grav fab',
				'fa-gripfire fab',
				'fa-grunt fab',
				'fa-guilded fab',
				'fa-gulp fab',
				'fa-hacker-news fab',
				'fa-hacker-news-square fab',
				'fa-hackerrank fab',
				'fa-hips fab',
				'fa-hire-a-helper fab',
				'fa-hive fab',
				'fa-hooli fab',
				'fa-hornbill fab',
				'fa-hotjar fab',
				'fa-houzz fab',
				'fa-html5 fab',
				'fa-hubspot fab',
				'fa-ideal fab',
				'fa-imdb fab',
				'fa-innosoft fab',
				'fa-instagram fab',
				'fa-instagram-square fab',
				'fa-instalod fab',
				'fa-intercom fab',
				'fa-internet-explorer fab',
				'fa-invision fab',
				'fa-ioxhost fab',
				'fa-itch-io fab',
				'fa-itunes fab',
				'fa-itunes-note fab',
				'fa-java fab',
				'fa-jedi-order fab',
				'fa-jenkins fab',
				'fa-jira fab',
				'fa-joget fab',
				'fa-joomla fab',
				'fa-js fab',
				'fa-js-square fab',
				'fa-jsfiddle fab',
				'fa-kaggle fab',
				'fa-keybase fab',
				'fa-keycdn fab',
				'fa-kickstarter fab',
				'fa-kickstarter-k fab',
				'fa-korvue fab',
				'fa-laravel fab',
				'fa-lastfm fab',
				'fa-lastfm-square fab',
				'fa-leanpub fab',
				'fa-less fab',
				'fa-line fab',
				'fa-linkedin fab',
				'fa-linkedin-in fab',
				'fa-linode fab',
				'fa-linux fab',
				'fa-lyft fab',
				'fa-magento fab',
				'fa-mailchimp fab',
				'fa-mandalorian fab',
				'fa-markdown fab',
				'fa-mastodon fab',
				'fa-maxcdn fab',
				'fa-mdb fab',
				'fa-medapps fab',
				'fa-medium fab',
				'fa-medium-m fab',
				'fa-medrt fab',
				'fa-meetup fab',
				'fa-megaport fab',
				'fa-mendeley fab',
				'fa-microblog fab',
				'fa-microsoft fab',
				'fa-mix fab',
				'fa-mixcloud fab',
				'fa-mixer fab',
				'fa-mizuni fab',
				'fa-modx fab',
				'fa-monero fab',
				'fa-napster fab',
				'fa-neos fab',
				'fa-nimblr fab',
				'fa-node fab',
				'fa-node-js fab',
				'fa-npm fab',
				'fa-ns8 fab',
				'fa-nutritionix fab',
				'fa-octopus-deploy fab',
				'fa-odnoklassniki fab',
				'fa-odnoklassniki-square fab',
				'fa-old-republic fab',
				'fa-opencart fab',
				'fa-openid fab',
				'fa-opera fab',
				'fa-optin-monster fab',
				'fa-orcid fab',
				'fa-osi fab',
				'fa-page4 fab',
				'fa-pagelines fab',
				'fa-palfed fab',
				'fa-patreon fab',
				'fa-paypal fab',
				'fa-penny-arcade fab',
				'fa-perbyte fab',
				'fa-periscope fab',
				'fa-phabricator fab',
				'fa-phoenix-framework fab',
				'fa-phoenix-squadron fab',
				'fa-php fab',
				'fa-pied-piper fab',
				'fa-pied-piper-alt fab',
				'fa-pied-piper-hat fab',
				'fa-pied-piper-pp fab',
				'fa-pied-piper-square fab',
				'fa-pinterest fab',
				'fa-pinterest-p fab',
				'fa-pinterest-square fab',
				'fa-playstation fab',
				'fa-product-hunt fab',
				'fa-pushed fab',
				'fa-python fab',
				'fa-qq fab',
				'fa-quinscape fab',
				'fa-quora fab',
				'fa-r-project fab',
				'fa-raspberry-pi fab',
				'fa-ravelry fab',
				'fa-react fab',
				'fa-reacteurope fab',
				'fa-readme fab',
				'fa-rebel fab',
				'fa-red-river fab',
				'fa-reddit fab',
				'fa-reddit-alien fab',
				'fa-reddit-square fab',
				'fa-redhat fab',
				'fa-renren fab',
				'fa-replyd fab',
				'fa-researchgate fab',
				'fa-resolving fab',
				'fa-rev fab',
				'fa-rocketchat fab',
				'fa-rockrms fab',
				'fa-rust fab',
				'fa-safari fab',
				'fa-salesforce fab',
				'fa-sass fab',
				'fa-schlix fab',
				'fa-scribd fab',
				'fa-searchengin fab',
				'fa-sellcast fab',
				'fa-sellsy fab',
				'fa-servicestack fab',
				'fa-shirtsinbulk fab',
				'fa-shopify fab',
				'fa-shopware fab',
				'fa-simplybuilt fab',
				'fa-sistrix fab',
				'fa-sith fab',
				'fa-sketch fab',
				'fa-skyatlas fab',
				'fa-skype fab',
				'fa-slack fab',
				'fa-slack-hash fab',
				'fa-slideshare fab',
				'fa-snapchat fab',
				'fa-snapchat-ghost fab',
				'fa-snapchat-square fab',
				'fa-soundcloud fab',
				'fa-sourcetree fab',
				'fa-speakap fab',
				'fa-speaker-deck fab',
				'fa-spotify fab',
				'fa-squarespace fab',
				'fa-stack-exchange fab',
				'fa-stack-overflow fab',
				'fa-stackpath fab',
				'fa-staylinked fab',
				'fa-steam fab',
				'fa-steam-square fab',
				'fa-steam-symbol fab',
				'fa-sticker-mule fab',
				'fa-strava fab',
				'fa-stripe fab',
				'fa-stripe-s fab',
				'fa-studiovinari fab',
				'fa-stumbleupon fab',
				'fa-stumbleupon-circle fab',
				'fa-superpowers fab',
				'fa-supple fab',
				'fa-suse fab',
				'fa-swift fab',
				'fa-symfony fab',
				'fa-teamspeak fab',
				'fa-telegram fab',
				'fa-telegram-plane fab',
				'fa-tencent-weibo fab',
				'fa-the-red-yeti fab',
				'fa-themeco fab',
				'fa-themeisle fab',
				'fa-think-peaks fab',
				'fa-tiktok fab',
				'fa-trade-federation fab',
				'fa-trello fab',
				'fa-tripadvisor fab',
				'fa-tumblr fab',
				'fa-tumblr-square fab',
				'fa-twitch fab',
				'fa-twitter fab',
				'fa-twitter-square fab',
				'fa-typo3 fab',
				'fa-uber fab',
				'fa-ubuntu fab',
				'fa-uikit fab',
				'fa-umbraco fab',
				'fa-uncharted fab',
				'fa-uniregistry fab',
				'fa-unity fab',
				'fa-unsplash fab',
				'fa-untappd fab',
				'fa-ups fab',
				'fa-usb fab',
				'fa-usps fab',
				'fa-ussunnah fab',
				'fa-vaadin fab',
				'fa-viacoin fab',
				'fa-viadeo fab',
				'fa-viadeo-square fab',
				'fa-viber fab',
				'fa-vimeo fab',
				'fa-vimeo-square fab',
				'fa-vimeo-v fab',
				'fa-vine fab',
				'fa-vk fab',
				'fa-vnv fab',
				'fa-vuejs fab',
				'fa-watchman-monitoring fab',
				'fa-waze fab',
				'fa-weebly fab',
				'fa-weibo fab',
				'fa-weixin fab',
				'fa-whatsapp fab',
				'fa-whatsapp-square fab',
				'fa-whmcs fab',
				'fa-wikipedia-w fab',
				'fa-windows fab',
				'fa-wix fab',
				'fa-wizards-of-the-coast fab',
				'fa-wodu fab',
				'fa-wolf-pack-battalion fab',
				'fa-wordpress fab',
				'fa-wordpress-simple fab',
				'fa-wpbeginner fab',
				'fa-wpexplorer fab',
				'fa-wpforms fab',
				'fa-wpressr fab',
				'fa-xbox fab',
				'fa-x-twitter fab',
				'fa-square-x-twitter fab',
				'fa-xing fab',
				'fa-xing-square fab',
				'fa-y-combinator fab',
				'fa-yahoo fab',
				'fa-yammer fab',
				'fa-yandex fab',
				'fa-yandex-international fab',
				'fa-yarn fab',
				'fa-yelp fab',
				'fa-yoast fab',
				'fa-youtube fab',
				'fa-youtube-square fab',
				'fa-zhihu fab',
			),

		) );
	endif;

}

/**
 * Properly migrate from FontAwesome 4 to FontAwesome 5 classnames
 * and return sanitized icon display class
 *
 * @since 2.1.15
 * @access public
 * @param string $icon
 * @return string
 */
function hoot_sanitize_fa( $icon ) {
	$icon = apply_filters( 'hoot_migration_icon', trim( $icon ) );
	$migration = array(
		'fa-airbnb' => 'fa-airbnb fab',
		'fa-app-store' => 'fa-app-store fab',
		'fa-app-store-ios' => 'fa-app-store-ios fab',
		'fa-audible' => 'fa-audible fab',
		'fa-bluesky' => 'fa-bluesky fab',
		'fa-cash-app' => 'fa-cash-app fab',
		'fa-figma' => 'fa-figma fab',
		'fa-kickstarter' => 'fa-kickstarter fab',
		'fa-medium' => 'fa-medium fab',
		'fa-shopify' => 'fa-shopify fab',
		'fa-threads' => 'fa-threads fab',
		'fa-square-threads' => 'fa-square-threads fab',
		'fa-x-twitter' => 'fa-x-twitter fab',
		'fa-square-x-twitter' => 'fa-square-x-twitter fab',

		'fa-500px' => 'fa-500px fab',
		'fa-address-book' => 'fa-address-book fas',
		'fa-address-book-o' => 'fa-address-book far',
		'fa-address-card' => 'fa-address-card fas',
		'fa-address-card-o' => 'fa-address-card far',
		'fa-adjust' => 'fa-adjust fas',
		'fa-adn' => 'fa-adn fab',
		'fa-align-center' => 'fa-align-center fas',
		'fa-align-justify' => 'fa-align-justify fas',
		'fa-align-left' => 'fa-align-left fas',
		'fa-align-right' => 'fa-align-right fas',
		'fa-amazon' => 'fa-amazon fab',
		'fa-ambulance' => 'fa-ambulance fas',
		'fa-american-sign-language-interpreting' => 'fa-american-sign-language-interpreting fas',
		'fa-anchor' => 'fa-anchor fas',
		'fa-android' => 'fa-android fab',
		'fa-angellist' => 'fa-angellist fab',
		'fa-angle-double-down' => 'fa-angle-double-down fas',
		'fa-angle-double-left' => 'fa-angle-double-left fas',
		'fa-angle-double-right' => 'fa-angle-double-right fas',
		'fa-angle-double-up' => 'fa-angle-double-up fas',
		'fa-angle-down' => 'fa-angle-down fas',
		'fa-angle-left' => 'fa-angle-left fas',
		'fa-angle-right' => 'fa-angle-right fas',
		'fa-angle-up' => 'fa-angle-up fas',
		'fa-apple' => 'fa-apple fab',
		'fa-archive' => 'fa-archive fas',
		'fa-area-chart' => 'fa-chart-area fas',
		'fa-arrow-circle-down' => 'fa-arrow-circle-down fas',
		'fa-arrow-circle-left' => 'fa-arrow-circle-left fas',
		'fa-arrow-circle-o-down' => 'fa-arrow-alt-circle-down far',
		'fa-arrow-circle-o-left' => 'fa-arrow-alt-circle-left far',
		'fa-arrow-circle-o-right' => 'fa-arrow-alt-circle-right far',
		'fa-arrow-circle-o-up' => 'fa-arrow-alt-circle-up far',
		'fa-arrow-circle-right' => 'fa-arrow-circle-right fas',
		'fa-arrow-circle-up' => 'fa-arrow-circle-up fas',
		'fa-arrow-down' => 'fa-arrow-down fas',
		'fa-arrow-left' => 'fa-arrow-left fas',
		'fa-arrow-right' => 'fa-arrow-right fas',
		'fa-arrows' => 'fa-arrows-alt fas',
		'fa-arrows-alt' => 'fa-expand-arrows-alt fas',
		'fa-arrows-h' => 'fa-arrows-alt-h fas',
		'fa-arrows-v' => 'fa-arrows-alt-v fas',
		'fa-arrow-up' => 'fa-arrow-up fas',
		'fa-assistive-listening-systems' => 'fa-assistive-listening-systems fas',
		'fa-asterisk' => 'fa-asterisk fas',
		'fa-at' => 'fa-at fas',
		'fa-audio-description' => 'fa-audio-description fas',
		'fa-backward' => 'fa-backward fas',
		'fa-balance-scale' => 'fa-balance-scale fas',
		'fa-ban' => 'fa-ban fas',
		'fa-bandcamp' => 'fa-bandcamp fab',
		'fa-bar-chart' => 'fa-chart-bar far',
		'fa-barcode' => 'fa-barcode fas',
		'fa-bars' => 'fa-bars fas',
		'fa-bath' => 'fa-bath fas',
		'fa-battery-empty' => 'fa-battery-empty fas',
		'fa-battery-full' => 'fa-battery-full fas',
		'fa-battery-half' => 'fa-battery-half fas',
		'fa-battery-quarter' => 'fa-battery-quarter fas',
		'fa-battery-three-quarters' => 'fa-battery-three-quarters fas',
		'fa-bed' => 'fa-bed fas',
		'fa-beer' => 'fa-beer fas',
		'fa-behance' => 'fa-behance fab',
		'fa-behance-square' => 'fa-behance-square fab',
		'fa-bell' => 'fa-bell fas',
		'fa-bell-o' => 'fa-bell far',
		'fa-bell-slash' => 'fa-bell-slash fas',
		'fa-bell-slash-o' => 'fa-bell-slash far',
		'fa-bicycle' => 'fa-bicycle fas',
		'fa-binoculars' => 'fa-binoculars fas',
		'fa-birthday-cake' => 'fa-birthday-cake fas',
		'fa-bitbucket' => 'fa-bitbucket fab',
		'fa-bitbucket-square' => 'fa-bitbucket fab',
		'fa-black-tie' => 'fa-black-tie fab',
		'fa-blind' => 'fa-blind fas',
		'fa-bluetooth' => 'fa-bluetooth fab',
		'fa-bluetooth-b' => 'fa-bluetooth-b fab',
		'fa-bold' => 'fa-bold fas',
		'fa-bolt' => 'fa-bolt fas',
		'fa-bomb' => 'fa-bomb fas',
		'fa-book' => 'fa-book fas',
		'fa-bookmark' => 'fa-bookmark fas',
		'fa-bookmark-o' => 'fa-bookmark far',
		'fa-braille' => 'fa-braille fas',
		'fa-briefcase' => 'fa-briefcase fas',
		'fa-btc' => 'fa-btc fab',
		'fa-bug' => 'fa-bug fas',
		'fa-building' => 'fa-building fas',
		'fa-building-o' => 'fa-building far',
		'fa-bullhorn' => 'fa-bullhorn fas',
		'fa-bullseye' => 'fa-bullseye fas',
		'fa-bus' => 'fa-bus fas',
		'fa-buysellads' => 'fa-buysellads fab',
		'fa-calculator' => 'fa-calculator fas',
		'fa-calendar' => 'fa-calendar-alt fas',
		'fa-calendar-check-o' => 'fa-calendar-check far',
		'fa-calendar-minus-o' => 'fa-calendar-minus far',
		'fa-calendar-o' => 'fa-calendar far',
		'fa-calendar-plus-o' => 'fa-calendar-plus far',
		'fa-calendar-times-o' => 'fa-calendar-times far',
		'fa-camera' => 'fa-camera fas',
		'fa-camera-retro' => 'fa-camera-retro fas',
		'fa-car' => 'fa-car fas',
		'fa-caret-down' => 'fa-caret-down fas',
		'fa-caret-left' => 'fa-caret-left fas',
		'fa-caret-right' => 'fa-caret-right fas',
		'fa-caret-square-o-down' => 'fa-caret-square-down far',
		'fa-caret-square-o-left' => 'fa-caret-square-left far',
		'fa-caret-square-o-right' => 'fa-caret-square-right far',
		'fa-caret-square-o-up' => 'fa-caret-square-up far',
		'fa-caret-up' => 'fa-caret-up fas',
		'fa-cart-arrow-down' => 'fa-cart-arrow-down fas',
		'fa-cart-plus' => 'fa-cart-plus fas',
		'fa-cc' => 'fa-closed-captioning far',
		'fa-cc-amex' => 'fa-cc-amex fab',
		'fa-cc-diners-club' => 'fa-cc-diners-club fab',
		'fa-cc-discover' => 'fa-cc-discover fab',
		'fa-cc-jcb' => 'fa-cc-jcb fab',
		'fa-cc-mastercard' => 'fa-cc-mastercard fab',
		'fa-cc-paypal' => 'fa-cc-paypal fab',
		'fa-cc-stripe' => 'fa-cc-stripe fab',
		'fa-cc-visa' => 'fa-cc-visa fab',
		'fa-certificate' => 'fa-certificate fas',
		'fa-chain-broken' => 'fa-unlink fas',
		'fa-check' => 'fa-check fas',
		'fa-check-circle' => 'fa-check-circle fas',
		'fa-check-circle-o' => 'fa-check-circle far',
		'fa-check-square' => 'fa-check-square fas',
		'fa-check-square-o' => 'fa-check-square far',
		'fa-chevron-circle-down' => 'fa-chevron-circle-down fas',
		'fa-chevron-circle-left' => 'fa-chevron-circle-left fas',
		'fa-chevron-circle-right' => 'fa-chevron-circle-right fas',
		'fa-chevron-circle-up' => 'fa-chevron-circle-up fas',
		'fa-chevron-down' => 'fa-chevron-down fas',
		'fa-chevron-left' => 'fa-chevron-left fas',
		'fa-chevron-right' => 'fa-chevron-right fas',
		'fa-chevron-up' => 'fa-chevron-up fas',
		'fa-child' => 'fa-child fas',
		'fa-chrome' => 'fa-chrome fab',
		'fa-circle' => 'fa-circle fas',
		'fa-circle-o' => 'fa-circle far',
		'fa-circle-o-notch' => 'fa-circle-notch fas',
		'fa-circle-thin' => 'fa-circle far',
		'fa-clipboard' => 'fa-clipboard fas',
		'fa-clock-o' => 'fa-clock far',
		'fa-clone' => 'fa-clone fas',
		'fa-cloud' => 'fa-cloud fas',
		'fa-cloud-download' => 'fa-cloud-download-alt fas',
		'fa-cloud-upload' => 'fa-cloud-upload-alt fas',
		'fa-code' => 'fa-code fas',
		'fa-code-fork' => 'fa-code-branch fas',
		'fa-codepen' => 'fa-codepen fab',
		'fa-codiepie' => 'fa-codiepie fab',
		'fa-coffee' => 'fa-coffee fas',
		'fa-cog' => 'fa-cog fas',
		'fa-cogs' => 'fa-cogs fas',
		'fa-columns' => 'fa-columns fas',
		'fa-comment' => 'fa-comment fas',
		'fa-commenting' => 'fa-comment-alt fas',
		'fa-commenting-o' => 'fa-comment-alt far',
		'fa-comment-o' => 'fa-comment far',
		'fa-comments' => 'fa-comments fas',
		'fa-comments-o' => 'fa-comments far',
		'fa-compass' => 'fa-compass fas',
		'fa-compress' => 'fa-compress fas',
		'fa-connectdevelop' => 'fa-connectdevelop fab',
		'fa-contao' => 'fa-contao fab',
		'fa-copyright' => 'fa-copyright fas',
		'fa-creative-commons' => 'fa-creative-commons fab',
		'fa-credit-card' => 'fa-credit-card fas',
		'fa-credit-card-alt' => 'fa-credit-card fas',
		'fa-crop' => 'fa-crop fas',
		'fa-crosshairs' => 'fa-crosshairs fas',
		'fa-css3' => 'fa-css3 fab',
		'fa-cube' => 'fa-cube fas',
		'fa-cubes' => 'fa-cubes fas',
		'fa-cutlery' => 'fa-utensils fas',
		'fa-dashcube' => 'fa-dashcube fab',
		'fa-database' => 'fa-database fas',
		'fa-deaf' => 'fa-deaf fas',
		'fa-delicious' => 'fa-delicious fab',
		'fa-desktop' => 'fa-desktop fas',
		'fa-deviantart' => 'fa-deviantart fab',
		'fa-diamond' => 'fa-gem far',
		'fa-digg' => 'fa-digg fab',
		'fa-discord' => 'fa-discord fab',
		'fa-dot-circle-o' => 'fa-dot-circle far',
		'fa-download' => 'fa-download fas',
		'fa-dribbble' => 'fa-dribbble fab',
		'fa-dropbox' => 'fa-dropbox fab',
		'fa-drupal' => 'fa-drupal fab',
		'fa-edge' => 'fa-edge fab',
		'fa-eercast' => 'fa-sellcast fab',
		'fa-eject' => 'fa-eject fas',
		'fa-ellipsis-h' => 'fa-ellipsis-h fas',
		'fa-ellipsis-v' => 'fa-ellipsis-v fas',
		'fa-empire' => 'fa-empire fab',
		'fa-envelope' => 'fa-envelope fas',
		'fa-envelope-o' => 'fa-envelope far',
		'fa-envelope-open' => 'fa-envelope-open fas',
		'fa-envelope-open-o' => 'fa-envelope-open far',
		'fa-envelope-square' => 'fa-envelope-square fas',
		'fa-envira' => 'fa-envira fab',
		'fa-eraser' => 'fa-eraser fas',
		'fa-etsy' => 'fa-etsy fab',
		'fa-eur' => 'fa-euro-sign fas',
		'fa-exchange' => 'fa-exchange-alt fas',
		'fa-exclamation' => 'fa-exclamation fas',
		'fa-exclamation-circle' => 'fa-exclamation-circle fas',
		'fa-exclamation-triangle' => 'fa-exclamation-triangle fas',
		'fa-expand' => 'fa-expand fas',
		'fa-expeditedssl' => 'fa-expeditedssl fab',
		'fa-external-link' => 'fa-external-link-alt fas',
		'fa-external-link-square' => 'fa-external-link-square-alt fas',
		'fa-eye' => 'fa-eye fas',
		'fa-eyedropper' => 'fa-eye-dropper fas',
		'fa-eye-slash' => 'fa-eye-slash fas',
		'fa-facebook' => 'fa-facebook-f fab',
		'fa-facebook-official' => 'fa-facebook fab',
		'fa-facebook-square' => 'fa-facebook-square fab',
		'fa-fast-backward' => 'fa-fast-backward fas',
		'fa-fast-forward' => 'fa-fast-forward fas',
		'fa-fax' => 'fa-fax fas',
		'fa-female' => 'fa-female fas',
		'fa-fighter-jet' => 'fa-fighter-jet fas',
		'fa-file' => 'fa-file fas',
		'fa-file-archive-o' => 'fa-file-archive far',
		'fa-file-audio-o' => 'fa-file-audio far',
		'fa-file-code-o' => 'fa-file-code far',
		'fa-file-excel-o' => 'fa-file-excel far',
		'fa-file-image-o' => 'fa-file-image far',
		'fa-file-o' => 'fa-file far',
		'fa-file-pdf-o' => 'fa-file-pdf far',
		'fa-file-powerpoint-o' => 'fa-file-powerpoint far',
		'fa-files-o' => 'fa-copy far',
		'fa-file-text' => 'fa-file-alt fas',
		'fa-file-text-o' => 'fa-file-alt far',
		'fa-file-video-o' => 'fa-file-video far',
		'fa-file-word-o' => 'fa-file-word far',
		'fa-film' => 'fa-film fas',
		'fa-filter' => 'fa-filter fas',
		'fa-fire' => 'fa-fire fas',
		'fa-fire-extinguisher' => 'fa-fire-extinguisher fas',
		'fa-firefox' => 'fa-firefox fab',
		'fa-first-order' => 'fa-first-order fab',
		'fa-flag' => 'fa-flag fas',
		'fa-flag-checkered' => 'fa-flag-checkered fas',
		'fa-flag-o' => 'fa-flag far',
		'fa-flask' => 'fa-flask fas',
		'fa-flickr' => 'fa-flickr fab',
		'fa-floppy-o' => 'fa-save far',
		'fa-folder' => 'fa-folder fas',
		'fa-folder-o' => 'fa-folder far',
		'fa-folder-open' => 'fa-folder-open fas',
		'fa-folder-open-o' => 'fa-folder-open far',
		'fa-font' => 'fa-font fas',
		'fa-font-awesome' => 'fa-font-awesome fab',
		'fa-fonticons' => 'fa-fonticons fab',
		'fa-fort-awesome' => 'fa-fort-awesome fab',
		'fa-forumbee' => 'fa-forumbee fab',
		'fa-forward' => 'fa-forward fas',
		'fa-foursquare' => 'fa-foursquare fab',
		'fa-free-code-camp' => 'fa-free-code-camp fab',
		'fa-frown-o' => 'fa-frown far',
		'fa-futbol-o' => 'fa-futbol far',
		'fa-gamepad' => 'fa-gamepad fas',
		'fa-gavel' => 'fa-gavel fas',
		'fa-gbp' => 'fa-pound-sign fas',
		'fa-genderless' => 'fa-genderless fas',
		'fa-get-pocket' => 'fa-get-pocket fab',
		'fa-gg' => 'fa-gg fab',
		'fa-gg-circle' => 'fa-gg-circle fab',
		'fa-gift' => 'fa-gift fas',
		'fa-git' => 'fa-git fab',
		'fa-github' => 'fa-github fab',
		'fa-github-alt' => 'fa-github-alt fab',
		'fa-github-square' => 'fa-github-square fab',
		'fa-gitlab' => 'fa-gitlab fab',
		'fa-git-square' => 'fa-git-square fab',
		'fa-glass' => 'fa-glass-martini fas',
		'fa-glide' => 'fa-glide fab',
		'fa-glide-g' => 'fa-glide-g fab',
		'fa-globe' => 'fa-globe fas',
		'fa-google' => 'fa-google fab',
		'fa-google-plus' => 'fa-google-plus-g fab',
		'fa-google-plus-official' => 'fa-google-plus fab',
		'fa-google-plus-square' => 'fa-google-plus-square fab',
		'fa-google-wallet' => 'fa-google-wallet fab',
		'fa-graduation-cap' => 'fa-graduation-cap fas',
		'fa-gratipay' => 'fa-gratipay fab',
		'fa-grav' => 'fa-grav fab',
		'fa-hacker-news' => 'fa-hacker-news fab',
		'fa-hand-lizard-o' => 'fa-hand-lizard far',
		'fa-hand-o-down' => 'fa-hand-point-down far',
		'fa-hand-o-left' => 'fa-hand-point-left far',
		'fa-hand-o-right' => 'fa-hand-point-right far',
		'fa-hand-o-up' => 'fa-hand-point-up far',
		'fa-hand-paper-o' => 'fa-hand-paper far',
		'fa-hand-peace-o' => 'fa-hand-peace far',
		'fa-hand-pointer-o' => 'fa-hand-pointer far',
		'fa-hand-rock-o' => 'fa-hand-rock far',
		'fa-hand-scissors-o' => 'fa-hand-scissors far',
		'fa-handshake-o' => 'fa-handshake far',
		'fa-hand-spock-o' => 'fa-hand-spock far',
		'fa-hashtag' => 'fa-hashtag fas',
		'fa-hdd-o' => 'fa-hdd far',
		'fa-header' => 'fa-heading fas',
		'fa-headphones' => 'fa-headphones fas',
		'fa-heart' => 'fa-heart fas',
		'fa-heartbeat' => 'fa-heartbeat fas',
		'fa-heart-o' => 'fa-heart far',
		'fa-history' => 'fa-history fas',
		'fa-home' => 'fa-home fas',
		'fa-hospital-o' => 'fa-hospital far',
		'fa-hourglass' => 'fa-hourglass fas',
		'fa-hourglass-end' => 'fa-hourglass-end fas',
		'fa-hourglass-half' => 'fa-hourglass-half fas',
		'fa-hourglass-o' => 'fa-hourglass far',
		'fa-hourglass-start' => 'fa-hourglass-start fas',
		'fa-houzz' => 'fa-houzz fab',
		'fa-h-square' => 'fa-h-square fas',
		'fa-html5' => 'fa-html5 fab',
		'fa-i-cursor' => 'fa-i-cursor fas',
		'fa-id-badge' => 'fa-id-badge fas',
		'fa-id-card' => 'fa-id-card fas',
		'fa-id-card-o' => 'fa-id-card far',
		'fa-ils' => 'fa-shekel-sign fas',
		'fa-imdb' => 'fa-imdb fab',
		'fa-inbox' => 'fa-inbox fas',
		'fa-indent' => 'fa-indent fas',
		'fa-industry' => 'fa-industry fas',
		'fa-info' => 'fa-info fas',
		'fa-info-circle' => 'fa-info-circle fas',
		'fa-inr' => 'fa-rupee-sign fas',
		'fa-instagram' => 'fa-instagram fab',
		'fa-internet-explorer' => 'fa-internet-explorer fab',
		'fa-ioxhost' => 'fa-ioxhost fab',
		'fa-italic' => 'fa-italic fas',
		'fa-joomla' => 'fa-joomla fab',
		'fa-jpy' => 'fa-yen-sign fas',
		'fa-jsfiddle' => 'fa-jsfiddle fab',
		'fa-key' => 'fa-key fas',
		'fa-keyboard-o' => 'fa-keyboard far',
		'fa-krw' => 'fa-won-sign fas',
		'fa-language' => 'fa-language fas',
		'fa-laptop' => 'fa-laptop fas',
		'fa-lastfm' => 'fa-lastfm fab',
		'fa-lastfm-square' => 'fa-lastfm-square fab',
		'fa-leaf' => 'fa-leaf fas',
		'fa-leanpub' => 'fa-leanpub fab',
		'fa-lemon-o' => 'fa-lemon far',
		'fa-level-down' => 'fa-level-down-alt fas',
		'fa-level-up' => 'fa-level-up-alt fas',
		'fa-life-ring' => 'fa-life-ring fas',
		'fa-lightbulb-o' => 'fa-lightbulb far',
		'fa-line-chart' => 'fa-chart-line fas',
		'fa-link' => 'fa-link fas',
		'fa-linkedin' => 'fa-linkedin-in fab',
		'fa-linkedin-square' => 'fa-linkedin fab',
		'fa-linode' => 'fa-linode fab',
		'fa-linux' => 'fa-linux fab',
		'fa-list' => 'fa-list fas',
		'fa-list-alt' => 'fa-list-alt fas',
		'fa-list-ol' => 'fa-list-ol fas',
		'fa-list-ul' => 'fa-list-ul fas',
		'fa-location-arrow' => 'fa-location-arrow fas',
		'fa-lock' => 'fa-lock fas',
		'fa-long-arrow-down' => 'fa-long-arrow-alt-down fas',
		'fa-long-arrow-left' => 'fa-long-arrow-alt-left fas',
		'fa-long-arrow-right' => 'fa-long-arrow-alt-right fas',
		'fa-long-arrow-up' => 'fa-long-arrow-alt-up fas',
		'fa-low-vision' => 'fa-low-vision fas',
		'fa-magic' => 'fa-magic fas',
		'fa-magnet' => 'fa-magnet fas',
		'fa-male' => 'fa-male fas',
		'fa-map' => 'fa-map fas',
		'fa-map-marker' => 'fa-map-marker-alt fas',
		'fa-map-o' => 'fa-map far',
		'fa-map-pin' => 'fa-map-pin fas',
		'fa-map-signs' => 'fa-map-signs fas',
		'fa-mars' => 'fa-mars fas',
		'fa-mars-double' => 'fa-mars-double fas',
		'fa-mars-stroke' => 'fa-mars-stroke fas',
		'fa-mars-stroke-h' => 'fa-mars-stroke-h fas',
		'fa-mars-stroke-v' => 'fa-mars-stroke-v fas',
		'fa-maxcdn' => 'fa-maxcdn fab',
		'fa-meanpath' => 'fa-font-awesome fab',
		'fa-medium' => 'fa-medium fab',
		'fa-medkit' => 'fa-medkit fas',
		'fa-meetup' => 'fa-meetup fab',
		'fa-meh-o' => 'fa-meh far',
		'fa-mercury' => 'fa-mercury fas',
		'fa-microchip' => 'fa-microchip fas',
		'fa-microphone' => 'fa-microphone fas',
		'fa-microphone-slash' => 'fa-microphone-slash fas',
		'fa-minus' => 'fa-minus fas',
		'fa-minus-circle' => 'fa-minus-circle fas',
		'fa-minus-square' => 'fa-minus-square fas',
		'fa-minus-square-o' => 'fa-minus-square far',
		'fa-mixcloud' => 'fa-mixcloud fab',
		'fa-mobile' => 'fa-mobile-alt fas',
		'fa-modx' => 'fa-modx fab',
		'fa-money' => 'fa-money-bill-alt far',
		'fa-moon-o' => 'fa-moon far',
		'fa-motorcycle' => 'fa-motorcycle fas',
		'fa-mouse-pointer' => 'fa-mouse-pointer fas',
		'fa-music' => 'fa-music fas',
		'fa-neuter' => 'fa-neuter fas',
		'fa-newspaper-o' => 'fa-newspaper far',
		'fa-object-group' => 'fa-object-group fas',
		'fa-object-ungroup' => 'fa-object-ungroup fas',
		'fa-odnoklassniki' => 'fa-odnoklassniki fab',
		'fa-odnoklassniki-square' => 'fa-odnoklassniki-square fab',
		'fa-opencart' => 'fa-opencart fab',
		'fa-openid' => 'fa-openid fab',
		'fa-opera' => 'fa-opera fab',
		'fa-optin-monster' => 'fa-optin-monster fab',
		'fa-outdent' => 'fa-outdent fas',
		'fa-pagelines' => 'fa-pagelines fab',
		'fa-paint-brush' => 'fa-paint-brush fas',
		'fa-paperclip' => 'fa-paperclip fas',
		'fa-paper-plane' => 'fa-paper-plane fas',
		'fa-paper-plane-o' => 'fa-paper-plane far',
		'fa-paragraph' => 'fa-paragraph fas',
		'fa-patreon' => 'fa-patreon fab',
		'fa-pause' => 'fa-pause fas',
		'fa-pause-circle' => 'fa-pause-circle fas',
		'fa-pause-circle-o' => 'fa-pause-circle far',
		'fa-paw' => 'fa-paw fas',
		'fa-paypal' => 'fa-paypal fab',
		'fa-pencil' => 'fa-pencil-alt fas',
		'fa-pencil-square' => 'fa-pen-square fas',
		'fa-pencil-square-o' => 'fa-edit far',
		'fa-percent' => 'fa-percent fas',
		'fa-phone' => 'fa-phone fas',
		'fa-phone-square' => 'fa-phone-square fas',
		'fa-picture-o' => 'fa-image far',
		'fa-pie-chart' => 'fa-chart-pie fas',
		'fa-pied-piper' => 'fa-pied-piper fab',
		'fa-pied-piper-alt' => 'fa-pied-piper-alt fab',
		'fa-pied-piper-pp' => 'fa-pied-piper-pp fab',
		'fa-pinterest' => 'fa-pinterest fab',
		'fa-pinterest-p' => 'fa-pinterest-p fab',
		'fa-pinterest-square' => 'fa-pinterest-square fab',
		'fa-plane' => 'fa-plane fas',
		'fa-play' => 'fa-play fas',
		'fa-play-circle' => 'fa-play-circle fas',
		'fa-play-circle-o' => 'fa-play-circle far',
		'fa-plug' => 'fa-plug fas',
		'fa-plus' => 'fa-plus fas',
		'fa-plus-circle' => 'fa-plus-circle fas',
		'fa-plus-square' => 'fa-plus-square fas',
		'fa-plus-square-o' => 'fa-plus-square far',
		'fa-podcast' => 'fa-podcast fas',
		'fa-power-off' => 'fa-power-off fas',
		'fa-print' => 'fa-print fas',
		'fa-product-hunt' => 'fa-product-hunt fab',
		'fa-puzzle-piece' => 'fa-puzzle-piece fas',
		'fa-qq' => 'fa-qq fab',
		'fa-qrcode' => 'fa-qrcode fas',
		'fa-question' => 'fa-question fas',
		'fa-question-circle' => 'fa-question-circle fas',
		'fa-question-circle-o' => 'fa-question-circle far',
		'fa-quora' => 'fa-quora fab',
		'fa-quote-left' => 'fa-quote-left fas',
		'fa-quote-right' => 'fa-quote-right fas',
		'fa-random' => 'fa-random fas',
		'fa-ravelry' => 'fa-ravelry fab',
		'fa-rebel' => 'fa-rebel fab',
		'fa-recycle' => 'fa-recycle fas',
		'fa-reddit' => 'fa-reddit fab',
		'fa-reddit-alien' => 'fa-reddit-alien fab',
		'fa-reddit-square' => 'fa-reddit-square fab',
		'fa-refresh' => 'fa-sync fas',
		'fa-registered' => 'fa-registered fas',
		'fa-renren' => 'fa-renren fab',
		'fa-repeat' => 'fa-redo fas',
		'fa-reply' => 'fa-reply fas',
		'fa-reply-all' => 'fa-reply-all fas',
		'fa-retweet' => 'fa-retweet fas',
		'fa-road' => 'fa-road fas',
		'fa-rocket' => 'fa-rocket fas',
		'fa-rss' => 'fa-rss fas',
		'fa-rss-square' => 'fa-rss-square fas',
		'fa-rub' => 'fa-ruble-sign fas',
		'fa-safari' => 'fa-safari fab',
		'fa-scissors' => 'fa-cut fas',
		'fa-scribd' => 'fa-scribd fab',
		'fa-search' => 'fa-search fas',
		'fa-search-minus' => 'fa-search-minus fas',
		'fa-search-plus' => 'fa-search-plus fas',
		'fa-sellsy' => 'fa-sellsy fab',
		'fa-server' => 'fa-server fas',
		'fa-share' => 'fa-share fas',
		'fa-share-alt' => 'fa-share-alt fas',
		'fa-share-alt-square' => 'fa-share-alt-square fas',
		'fa-share-square' => 'fa-share-square fas',
		'fa-share-square-o' => 'fa-share-square far',
		'fa-shield' => 'fa-shield-alt fas',
		'fa-ship' => 'fa-ship fas',
		'fa-shirtsinbulk' => 'fa-shirtsinbulk fab',
		'fa-shopping-bag' => 'fa-shopping-bag fas',
		'fa-shopping-basket' => 'fa-shopping-basket fas',
		'fa-shopping-cart' => 'fa-shopping-cart fas',
		'fa-shower' => 'fa-shower fas',
		'fa-signal' => 'fa-signal fas',
		'fa-sign-in' => 'fa-sign-in-alt fas',
		'fa-sign-language' => 'fa-sign-language fas',
		'fa-sign-out' => 'fa-sign-out-alt fas',
		'fa-simplybuilt' => 'fa-simplybuilt fab',
		'fa-sitemap' => 'fa-sitemap fas',
		'fa-skyatlas' => 'fa-skyatlas fab',
		'fa-skype' => 'fa-skype fab',
		'fa-slack' => 'fa-slack fab',
		'fa-sliders' => 'fa-sliders-h fas',
		'fa-slideshare' => 'fa-slideshare fab',
		'fa-smile-o' => 'fa-smile far',
		'fa-snapchat' => 'fa-snapchat fab',
		'fa-snapchat-ghost' => 'fa-snapchat-ghost fab',
		'fa-snapchat-square' => 'fa-snapchat-square fab',
		'fa-snowflake-o' => 'fa-snowflake far',
		'fa-sort' => 'fa-sort fas',
		'fa-sort-alpha-asc' => 'fa-sort-alpha-down fas',
		'fa-sort-alpha-desc' => 'fa-sort-alpha-up fas',
		'fa-sort-amount-asc' => 'fa-sort-amount-down fas',
		'fa-sort-amount-desc' => 'fa-sort-amount-up fas',
		'fa-sort-asc' => 'fa-sort-up fas',
		'fa-sort-desc' => 'fa-sort-down fas',
		'fa-sort-numeric-asc' => 'fa-sort-numeric-down fas',
		'fa-sort-numeric-desc' => 'fa-sort-numeric-up fas',
		'fa-soundcloud' => 'fa-soundcloud fab',
		'fa-space-shuttle' => 'fa-space-shuttle fas',
		'fa-spinner' => 'fa-spinner fas',
		'fa-spoon' => 'fa-utensil-spoon fas',
		'fa-spotify' => 'fa-spotify fab',
		'fa-square' => 'fa-square fas',
		'fa-square-o' => 'fa-square far',
		'fa-stack-exchange' => 'fa-stack-exchange fab',
		'fa-stack-overflow' => 'fa-stack-overflow fab',
		'fa-star' => 'fa-star fas',
		'fa-star-half' => 'fa-star-half fas',
		'fa-star-half-o' => 'fa-star-half far',
		'fa-star-o' => 'fa-star far',
		'fa-steam' => 'fa-steam fab',
		'fa-steam-square' => 'fa-steam-square fab',
		'fa-step-backward' => 'fa-step-backward fas',
		'fa-step-forward' => 'fa-step-forward fas',
		'fa-stethoscope' => 'fa-stethoscope fas',
		'fa-sticky-note' => 'fa-sticky-note fas',
		'fa-sticky-note-o' => 'fa-sticky-note far',
		'fa-stop' => 'fa-stop fas',
		'fa-stop-circle' => 'fa-stop-circle fas',
		'fa-stop-circle-o' => 'fa-stop-circle far',
		'fa-street-view' => 'fa-street-view fas',
		'fa-strikethrough' => 'fa-strikethrough fas',
		'fa-stumbleupon' => 'fa-stumbleupon fab',
		'fa-stumbleupon-circle' => 'fa-stumbleupon-circle fab',
		'fa-subscript' => 'fa-subscript fas',
		'fa-subway' => 'fa-subway fas',
		'fa-suitcase' => 'fa-suitcase fas',
		'fa-sun-o' => 'fa-sun far',
		'fa-superpowers' => 'fa-superpowers fab',
		'fa-superscript' => 'fa-superscript fas',
		'fa-table' => 'fa-table fas',
		'fa-tablet' => 'fa-tablet-alt fas',
		'fa-tachometer' => 'fa-tachometer-alt fas',
		'fa-tag' => 'fa-tag fas',
		'fa-tags' => 'fa-tags fas',
		'fa-tasks' => 'fa-tasks fas',
		'fa-taxi' => 'fa-taxi fas',
		'fa-telegram' => 'fa-telegram fab',
		'fa-television' => 'fa-tv fas',
		'fa-tencent-weibo' => 'fa-tencent-weibo fab',
		'fa-terminal' => 'fa-terminal fas',
		'fa-text-height' => 'fa-text-height fas',
		'fa-text-width' => 'fa-text-width fas',
		'fa-th' => 'fa-th fas',
		'fa-themeisle' => 'fa-themeisle fab',
		'fa-thermometer-empty' => 'fa-thermometer-empty fas',
		'fa-thermometer-full' => 'fa-thermometer-full fas',
		'fa-thermometer-half' => 'fa-thermometer-half fas',
		'fa-thermometer-quarter' => 'fa-thermometer-quarter fas',
		'fa-thermometer-three-quarters' => 'fa-thermometer-three-quarters fas',
		'fa-th-large' => 'fa-th-large fas',
		'fa-th-list' => 'fa-th-list fas',
		'fa-thumbs-down' => 'fa-thumbs-down fas',
		'fa-thumbs-o-down' => 'fa-thumbs-down far',
		'fa-thumbs-o-up' => 'fa-thumbs-up far',
		'fa-thumbs-up' => 'fa-thumbs-up fas',
		'fa-thumb-tack' => 'fa-thumbtack fas',
		'fa-ticket' => 'fa-ticket-alt fas',
		'fa-tiktok' => 'fa-tiktok fab',
		'fa-times' => 'fa-times fas',
		'fa-times-circle' => 'fa-times-circle fas',
		'fa-times-circle-o' => 'fa-times-circle far',
		'fa-tint' => 'fa-tint fas',
		'fa-toggle-off' => 'fa-toggle-off fas',
		'fa-toggle-on' => 'fa-toggle-on fas',
		'fa-trademark' => 'fa-trademark fas',
		'fa-train' => 'fa-train fas',
		'fa-transgender' => 'fa-transgender fas',
		'fa-transgender-alt' => 'fa-transgender-alt fas',
		'fa-trash' => 'fa-trash-alt fas',
		'fa-trash-o' => 'fa-trash-alt far',
		'fa-tree' => 'fa-tree fas',
		'fa-trello' => 'fa-trello fab',
		'fa-tripadvisor' => 'fa-tripadvisor fab',
		'fa-trophy' => 'fa-trophy fas',
		'fa-truck' => 'fa-truck fas',
		'fa-try' => 'fa-lira-sign fas',
		'fa-tty' => 'fa-tty fas',
		'fa-tumblr' => 'fa-tumblr fab',
		'fa-tumblr-square' => 'fa-tumblr-square fab',
		'fa-twitch' => 'fa-twitch fab',
		'fa-twitter' => 'fa-twitter fab',
		'fa-twitter-square' => 'fa-twitter-square fab',
		'fa-umbrella' => 'fa-umbrella fas',
		'fa-underline' => 'fa-underline fas',
		'fa-undo' => 'fa-undo fas',
		'fa-universal-access' => 'fa-universal-access fas',
		'fa-university' => 'fa-university fas',
		'fa-unlock' => 'fa-unlock fas',
		'fa-unlock-alt' => 'fa-unlock-alt fas',
		'fa-upload' => 'fa-upload fas',
		'fa-usb' => 'fa-usb fab',
		'fa-usd' => 'fa-dollar-sign fas',
		'fa-user' => 'fa-user fas',
		'fa-user-circle' => 'fa-user-circle fas',
		'fa-user-circle-o' => 'fa-user-circle far',
		'fa-user-md' => 'fa-user-md fas',
		'fa-user-o' => 'fa-user far',
		'fa-user-plus' => 'fa-user-plus fas',
		'fa-users' => 'fa-users fas',
		'fa-user-secret' => 'fa-user-secret fas',
		'fa-user-times' => 'fa-user-times fas',
		'fa-venus' => 'fa-venus fas',
		'fa-venus-double' => 'fa-venus-double fas',
		'fa-venus-mars' => 'fa-venus-mars fas',
		'fa-viacoin' => 'fa-viacoin fab',
		'fa-viadeo' => 'fa-viadeo fab',
		'fa-viadeo-square' => 'fa-viadeo-square fab',
		'fa-video-camera' => 'fa-video fas',
		'fa-vimeo' => 'fa-vimeo-v fab',
		'fa-vimeo-square' => 'fa-vimeo-square fab',
		'fa-vine' => 'fa-vine fab',
		'fa-vk' => 'fa-vk fab',
		'fa-volume-control-phone' => 'fa-phone-volume fas',
		'fa-volume-down' => 'fa-volume-down fas',
		'fa-volume-off' => 'fa-volume-off fas',
		'fa-volume-up' => 'fa-volume-up fas',
		'fa-weibo' => 'fa-weibo fab',
		'fa-weixin' => 'fa-weixin fab',
		'fa-whatsapp' => 'fa-whatsapp fab',
		'fa-wheelchair' => 'fa-wheelchair fas',
		'fa-wheelchair-alt' => 'fa-accessible-icon fab',
		'fa-wifi' => 'fa-wifi fas',
		'fa-wikipedia-w' => 'fa-wikipedia-w fab',
		'fa-window-close' => 'fa-window-close fas',
		'fa-window-close-o' => 'fa-window-close far',
		'fa-window-maximize' => 'fa-window-maximize fas',
		'fa-window-minimize' => 'fa-window-minimize fas',
		'fa-window-restore' => 'fa-window-restore fas',
		'fa-windows' => 'fa-windows fab',
		'fa-wordpress' => 'fa-wordpress fab',
		'fa-wpbeginner' => 'fa-wpbeginner fab',
		'fa-wpexplorer' => 'fa-wpexplorer fab',
		'fa-wpforms' => 'fa-wpforms fab',
		'fa-wrench' => 'fa-wrench fas',
		'fa-x-twitter' => 'fa-x-twitter fab',
		'fa-square-x-twitter' => 'fa-square-x-twitter fab',
		'fa-xing' => 'fa-xing fab',
		'fa-xing-square' => 'fa-xing-square fab',
		'fa-yahoo' => 'fa-yahoo fab',
		'fa-y-combinator' => 'fa-y-combinator fab',
		'fa-yelp' => 'fa-yelp fab',
		'fa-yoast' => 'fa-yoast fab',
		'fa-youtube' => 'fa-youtube fab',
		'fa-youtube-play' => 'fa-youtube fab',
		'fa-youtube-square' => 'fa-youtube fab',
	);

	// Sanitize and return icon
	if ( empty( $migration[$icon] ) ) {
		$iconarray = ( is_string( $icon ) ) ? explode( " ", $icon ) : NULL;
		if ( is_array( $iconarray ) && count( $iconarray ) > 0 ) {
			$iconarray = array_map( "sanitize_html_class", $iconarray );
			return implode( " ", $iconarray );
		} else { 
			return '';
		}
	} else {
		return $migration[$icon];
	}
}