/*! boids-canvas 2016-01-25 */
var Vector=function(a,b){"undefined"===a&&(a=0),"undefined"===b&&(b=0),this.x=a,this.y=b};Vector.prototype.add=function(a){return new Vector(this.x+a.x,this.y+a.y)},Vector.prototype.sub=function(a){return new Vector(this.x-a.x,this.y-a.y)},Vector.prototype.mul=function(a){return new Vector(this.x*a.x,this.y*a.y)},Vector.prototype.div=function(a){return new Vector(this.x/a.x,this.y/a.y)},Vector.prototype.mag=function(){return Math.sqrt(this.x*this.x+this.y*this.y)},Vector.prototype.normalise=function(a){var b=this.mag();return new Vector(this.x/b,this.y/b)},Vector.prototype.dist=function(a){return Math.sqrt((this.x-a.x)*(this.x-a.x)+(this.y-a.y)*(this.y-a.y))},Vector.prototype.limit=function(a){var b;return b=this.mag()>a?this.normalise().mul(new Vector(a,a)):this};var Boid=function(a,b,c,d,e){return this.position=new Vector(b.x,b.y),this.velocity=new Vector(c.x,c.y),this.acceleration=new Vector(0,0),/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)?(this.size=d,this.colour=e,void(this.parent=a)):(console.error("Please specify a valid boid hexadecimal color"),!1)};Boid.prototype.draw=function(){this.parent.ctx.beginPath(),this.parent.ctx.fillStyle=this.colour,this.parent.ctx.globalAlpha=.7,this.parent.ctx.arc(this.position.x,this.position.y,this.parent.boidRadius*this.size,0,2*Math.PI),this.parent.ctx.fill()},Boid.prototype.update=function(){var a=this.cohesion(),b=this.separation(),c=this.alignment(),d=this.interactivity();a=a.mul(new Vector(1,1)),b=b.mul(new Vector(1.5,1.5)),c=c.mul(new Vector(1,1)),d=d.mul(new Vector(1.8,1.8)),this.applyForce(a),this.applyForce(b),this.applyForce(c),this.applyForce(d),this.velocity=this.velocity.add(this.acceleration),this.velocity=this.velocity.limit(this.parent.options.speed),this.position=this.position.add(this.velocity),this.acceleration=this.acceleration.mul(new Vector(0,0)),this.borders()},Boid.prototype.cohesion=function(){for(var a=new Vector(0,0),b=0,c=0;c<this.parent.boids.length;c++){var d=this.position.dist(this.parent.boids[c].position);d>0&&d<this.parent.visibleRadius&&(a=a.add(this.parent.boids[c].position),b++)}return b>0?(a=a.div(new Vector(b,b)),a=this.seek(a)):new Vector(0,0)},Boid.prototype.separation=function(){for(var a=new Vector(0,0),b=0,c=0;c<this.parent.boids.length;c++){var d=this.position.dist(this.parent.boids[c].position)-this.size*this.parent.boidRadius;if(d>0&&d<this.parent.separationDist){var e=this.position.sub(this.parent.boids[c].position);e=e.normalise(),e=e.div(new Vector(d,d)),a=a.add(e),b++}}return b>0&&(a=a.div(new Vector(b,b))),a.mag()>0&&(a=a.normalise(),a=a.mul(new Vector(this.parent.options.speed,this.parent.options.speed)),a=a.sub(this.velocity),a=a.limit(this.parent.maxForce)),a},Boid.prototype.alignment=function(){for(var a=new Vector(0,0),b=0,c=0;c<this.parent.boids.length;c++){var d=this.position.dist(this.parent.boids[c].position);d>0&&d<this.parent.visibleRadius&&(a=a.add(this.parent.boids[c].velocity),b++)}if(b>0){a=a.div(new Vector(b,b)),a=a.normalise(),a=a.mul(new Vector(this.parent.options.speed,this.parent.options.speed));var e=a.sub(this.velocity);return e=e.limit(this.parent.maxForce)}return new Vector(0,0)},Boid.prototype.interactivity=function(){return this.parent.options.interactive&&void 0!==this.parent.mousePos&&this.position.dist(this.parent.mousePos)<this.parent.visibleRadius?this.seek(this.parent.mousePos):new Vector(0,0)},Boid.prototype.borders=function(){this.position.x<0&&(this.position.x=this.parent.canvas.width),this.position.y<0&&(this.position.y=this.parent.canvas.height),this.position.x>this.parent.canvas.width&&(this.position.x=0),this.position.y>this.parent.canvas.height&&(this.position.y=0)},Boid.prototype.seek=function(a){var b=a.sub(this.position);b=b.normalise(),b=b.mul(new Vector(this.parent.options.speed,this.parent.options.speed));var c=b.sub(this.velocity);return c=c.limit(this.parent.maxForce)},Boid.prototype.applyForce=function(a){this.acceleration=this.acceleration.add(a.div(new Vector(this.size,this.size)))};var BoidsCanvas=function(a,b){this.canvasDiv=a,this.canvasDiv.size={width:this.canvasDiv.offsetWidth,height:this.canvasDiv.offsetHeight},b=void 0!==b?b:{},this.options={background:void 0!==b.background?b.background:"#1a252f",density:this.setDensity(b.density),speed:this.setSpeed(b.speed),interactive:void 0!==b.interactive?b.interactive:!0,mixedSizes:void 0!==b.mixedSizes?b.mixedSizes:!0,boidColours:void 0!==b.boidColours&&0!==b.boidColours.length?b.boidColours:["#ff3333"]},this.visibleRadius=150,this.maxForce=.04,this.separationDist=80,this.boidRadius=5,this.init()};BoidsCanvas.prototype.init=function(){if(this.bgDiv=document.createElement("div"),this.canvasDiv.appendChild(this.bgDiv),this.setStyles(this.bgDiv,{position:"absolute",top:0,left:0,bottom:0,right:0,"z-index":1}),/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(this.options.background))this.setStyles(this.bgDiv,{background:this.options.background});else{if(!/\.(gif|jpg|jpeg|tiff|png)$/i.test(this.options.background))return console.error("Please specify a valid background image or hexadecimal color"),!1;this.setStyles(this.bgDiv,{background:'url("'+this.options.background+'") no-repeat center',"background-size":"cover"})}this.canvas=document.createElement("canvas"),this.canvasDiv.appendChild(this.canvas),this.ctx=this.canvas.getContext("2d"),this.canvas.width=this.canvasDiv.size.width,this.canvas.height=this.canvasDiv.size.height,this.setStyles(this.canvasDiv,{position:"relative"}),this.setStyles(this.canvas,{"z-index":"20",position:"relative"}),window.addEventListener("resize",function(){return this.canvasDiv.offsetWidth===this.canvasDiv.size.width&&this.canvasDiv.offsetHeight===this.canvasDiv.size.height?!1:(this.canvas.width=this.canvasDiv.size.width=this.canvasDiv.offsetWidth,this.canvas.height=this.canvasDiv.size.height=this.canvasDiv.offsetHeight,void this.initialiseBoids())}.bind(this)),this.initialiseBoids(),this.canvas.addEventListener("mousemove",function(a){this.mousePos=new Vector(a.clientX-this.canvas.offsetLeft,a.clientY-this.canvas.offsetTop)}.bind(this)),this.canvas.addEventListener("mouseleave",function(a){this.mousePos=void 0}.bind(this)),requestAnimationFrame(this.update.bind(this))},BoidsCanvas.prototype.initialiseBoids=function(){this.boids=[];for(var a=0;a<this.canvas.width*this.canvas.height/this.options.density;a++){var b=new Vector(Math.floor(Math.random()*(this.canvas.width+1)),Math.floor(Math.random()*(this.canvas.height+1))),c=5,d=-5,e=new Vector(Math.floor(Math.random()*(c-d+1)+d),Math.floor(Math.random()*(c-d+1)+d)),f=this.options.mixedSizes?Math.floor(3*Math.random()+1):1,g=Math.floor(Math.random()*(this.options.boidColours.length-1+1));this.boids.push(new Boid(this,b,e,f,this.options.boidColours[g]))}},BoidsCanvas.prototype.update=function(){this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height),this.ctx.globalAlpha=1;for(var a=0;a<this.boids.length;a++)this.boids[a].update(),this.boids[a].draw();requestAnimationFrame(this.update.bind(this))},BoidsCanvas.prototype.setSpeed=function(a){return"fast"===a?3:"slow"===a?1:2},BoidsCanvas.prototype.setDensity=function(a){return"high"===a?5e3:"low"===a?2e4:1e4},BoidsCanvas.prototype.setStyles=function(a,b){for(var c in b)a.style[c]=b[c]};