<?php
$enable_theme_latest_post = reelcraft_get_option('enable_theme_latest_post');
$theme_latest_post_video_on = reelcraft_get_option('theme_latest_post_video_on');
$theme_latest_post_category = reelcraft_get_option('theme_latest_post_category');
$enable_theme_latest_post_category_meta = reelcraft_get_option('enable_theme_latest_post_category_meta');
$select_theme_latest_post_category_color = reelcraft_get_option('select_theme_latest_post_category_color');
$select_theme_latest_post_number_of_category = reelcraft_get_option('select_theme_latest_post_number_of_category');
$theme_latest_post_category_label = reelcraft_get_option('theme_latest_post_category_label');

$enable_theme_latest_post_author_meta = reelcraft_get_option('enable_theme_latest_post_author_meta');
$select_theme_latest_post_author_meta = reelcraft_get_option('select_theme_latest_post_author_meta');
$theme_latest_post_author_meta_title = reelcraft_get_option('theme_latest_post_author_meta_title');

$enable_theme_latest_post_date_meta = reelcraft_get_option('enable_theme_latest_post_date_meta');
$select_theme_latest_post_date = reelcraft_get_option('select_theme_latest_post_date');
$select_theme_latest_post_date_meta_title = reelcraft_get_option('select_theme_latest_post_date_meta_title');
$select_theme_latest_post_date_format = reelcraft_get_option('select_theme_latest_post_date_format');
$theme_latest_post_title = reelcraft_get_option('theme_latest_post_title');
$theme_latest_post_button_text = reelcraft_get_option('theme_latest_post_button_text');
$theme_latest_post_button_url = reelcraft_get_option('theme_latest_post_button_url');
$enable_theme_latest_post_category_meta = reelcraft_get_option('enable_theme_latest_post_category_meta');

$post_args = array(
  'post_type' => 'post',
  'posts_per_page' => 3,
  'post_status' => 'publish',
  'orderby' => 'date',
  'order' => 'DESC',
  'ignore_sticky_posts' => 1
);
if (!empty($theme_latest_post_category)) :
    $post_args['tax_query'][] = array(
        'taxonomy' => 'category',
        'field' => 'term_id',
        'terms' => absint($theme_latest_post_category),
    );
endif;

$theme_latest_post_posts = new WP_Query($post_args);
$archive_image_class = 'entry-image-big image-has-radius';
$archive_image_size = '';
?>

<?php if ($enable_theme_latest_post) { ?>
  <div class="wpi-section theme-latest-blog">
    <div class="wrapper wrapper-gutter-medium">
      <div class="row-group">
        <div class="column column-12">
          <?php if (!empty($theme_latest_post_title)) { ?>
            <header class="theme-section-header">
                <h2 class="theme-header-title"> <?php echo esc_html($theme_latest_post_title); ?> </h2>
            </header>
          <?php } ?>
          <div class="theme-section-body">
            <div class="row-group">
              <?php 
              if($theme_latest_post_posts->have_posts()) :
                while ($theme_latest_post_posts->have_posts()) : $theme_latest_post_posts->the_post();
                $post_index = $theme_latest_post_posts->current_post; ?>
                  <div class="column column-lg-4 column-md-6">
                    <article id="featured-block-<?php the_ID(); ?>" <?php post_class('wpi-post'); ?>>
                      <?php if ($theme_latest_post_video_on) { ?>
                          <div class="content-has-video">
                            <?php 
                            $content = get_the_content();
                                if (has_block('core/video', $content)) {
                                    reelcraft_instance_of_block('core/video', $content);
                                } elseif (has_block('core/embed', $content)) {
                                    reelcraft_instance_of_block('core/embed', $content);
                                }
                                  reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                            ?>
                          </div>
                      <?php } else {
                          reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                      } ?>
                      <div class="entry-details">
                        <?php
                          if ($enable_theme_latest_post_category_meta) {
                              reelcraft_post_category($select_theme_latest_post_category_color, $theme_latest_post_category_label, $select_theme_latest_post_number_of_category);
                          }
                        ?>

                        <h2 class="entry-title entry-title-medium limit-line-3">
                          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h2>
              
                        <div class="entry-meta-wrapper">
              
                            <?php
                            if ($enable_theme_latest_post_date_meta) {
                                reelcraft_posted_on($select_theme_latest_post_date_format, $select_theme_latest_post_date_meta_title, $select_theme_latest_post_date);
                            }
                            ?>
              
                            <?php
                            if ($enable_theme_latest_post_date_meta && $enable_theme_latest_post_author_meta) { ?>
                                <div class="entry-meta-separator"></div>
                            <?php } ?>
              
                            <?php
                            if ($enable_theme_latest_post_author_meta) {
                                reelcraft_posted_by($select_theme_latest_post_author_meta, $theme_latest_post_author_meta_title);
                            }
                            ?>
              
                        </div>
                        
                      </div>
                    </article>
                  </div>
              <?php endwhile; ?>
              <?php wp_reset_postdata(); // Reset post data ?>
              <?php endif; ?>
            </div>
          </div>

          <a class="view-more" href="<?php echo esc_url($theme_latest_post_button_url) ?>"> <?php echo esc_html($theme_latest_post_button_text); ?> </a>
        </div>
      </div>
    </div>
  </div>
<?php } ?>