<?php
$enable_main_banner_section = reelcraft_get_option('enable_main_banner_section');
$banner_slider_post_category = reelcraft_get_option('banner_slider_post_category');

$banner_lists_post_category = reelcraft_get_option('banner_lists_post_category');

$banner_featured_player_category = reelcraft_get_option('banner_featured_player_category');

$enable_main_banner_author_meta = reelcraft_get_option('enable_main_banner_author_meta');
$select_main_banner_author_meta = reelcraft_get_option('select_main_banner_author_meta');
$main_banner_author_meta_title = reelcraft_get_option('main_banner_author_meta_title');

$enable_main_banner_date_meta = reelcraft_get_option('enable_main_banner_date_meta');
$select_main_banner_date = reelcraft_get_option('select_main_banner_date');
$select_main_banner_date_meta_title = reelcraft_get_option('select_main_banner_date_meta_title');
$select_main_banner_date_format = reelcraft_get_option('select_main_banner_date_format');

$enable_main_banner_category_meta = reelcraft_get_option('enable_main_banner_category_meta');
$main_banner_category_label = reelcraft_get_option('main_banner_category_label');
$select_main_banner_category_color = reelcraft_get_option('select_main_banner_category_color');
$select_main_banner_number_of_category = reelcraft_get_option('select_main_banner_number_of_category');
if (empty($enable_main_banner_section)) {
    return;
}
?>

<section class="theme-main-banner custom-swiper-pagination">
  <div class="main-banner-slider swiper">
    <div class="swiper-wrapper">
        <?php
        // post slider section
        $post_slider_args = array(
            'post_type' => 'post',
            'posts_per_page' => 5,
            'post_status' => 'publish',
            'no_found_rows' => 1,
            'ignore_sticky_posts' => 1,
        );
        // Check for category.
        if (!empty($banner_slider_post_category)) :
            $post_slider_args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $banner_slider_post_category,
                ),
            );
        endif;
        $slider_posts = new WP_Query($post_slider_args);
        if ($slider_posts->have_posts()) :
            while ($slider_posts->have_posts()) :
                $slider_posts->the_post(); ?>
                <div class="swiper-slide">
                  <article id="main-banner-<?php the_ID(); ?>" class="wpi-post">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="entry-image">
                            <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true"
                                tabindex="-1">
                                <?php
                                the_post_thumbnail(
                                    'full',
                                    array(
                                        'alt' => the_title_attribute(
                                            array(
                                                'echo' => false,
                                            )
                                        ),
                                    )
                                );
                                ?>
                            </a>
                        </div>
                    <?php endif; ?>

                    <div class="entry-details">
                      <div class="wrapper">
                        <div class="entry-details-content">
                          <?php
                          if ($enable_main_banner_category_meta) {
                              reelcraft_post_category($select_main_banner_category_color, $main_banner_category_label, $select_main_banner_number_of_category);
                          }
                          ?>
                          <h3 class="entry-title entry-title-large">
                              <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                          </h3>
    
                          <div class="entry-content-excerpt">
                              <?php echo wpautop(wp_kses_post(reelcraft_get_archive_excerpt())); ?>
                          </div>
    
                          <div class="entry-meta-wrapper">
    
                              <?php
                              if ($enable_main_banner_date_meta) {
                                  reelcraft_posted_on($select_main_banner_date_format, $select_main_banner_date_meta_title, $select_main_banner_date);
                              }
                              ?>
    
                              <?php
                              if ($enable_main_banner_author_meta) {
                                  reelcraft_posted_by($select_main_banner_author_meta, $main_banner_author_meta_title);
                              }
                              ?>
    
                          </div>

                          <a href="<?php the_permalink(); ?>" class="wpi-button wpi-button-primary main-banner-btn with-icon">
                            <span>
                              Watch Now
                              
                              <?php reelcraft_the_theme_svg('play'); ?>
                            </span>
                          </a>
                        </div>
                      </div>
                    </div>
                  </article>
                </div>
            <?php
            endwhile;
          wp_reset_postdata();
        endif; ?>
    </div>

    <div class="swiper-pagination"></div>
  </div>
</section>