<?php
$enable_article_list_section = reelcraft_get_option('enable_article_list_section');
$article_list_post_video_on = reelcraft_get_option('article_list_post_video_on');
$select_article_list_title = reelcraft_get_option('select_article_list_title');
$article_list_post_category = reelcraft_get_option('article_list_post_category');

$enable_article_list_author_meta = reelcraft_get_option('enable_article_list_author_meta');
$select_article_list_author_meta = reelcraft_get_option('select_article_list_author_meta');
$article_list_author_meta_title = reelcraft_get_option('article_list_author_meta_title');

$enable_article_list_date_meta = reelcraft_get_option('enable_article_list_date_meta');
$select_article_list_date = reelcraft_get_option('select_article_list_date');
$select_article_list_date_meta_title = reelcraft_get_option('select_article_list_date_meta_title');
$select_article_list_date_format = reelcraft_get_option('select_article_list_date_format');

$enable_article_list_category_meta = reelcraft_get_option('enable_article_list_category_meta');
$article_list_category_label = reelcraft_get_option('article_list_category_label');
$select_article_list_category_color = reelcraft_get_option('select_article_list_category_color');
$select_article_list_number_of_category = reelcraft_get_option('select_article_list_number_of_category');
if (empty($enable_article_list_section)) {
    return;
}
$archive_image_class = 'entry-image-medium image-has-radius';
$archive_image_size = '';
?>

<section class="wpi-section theme-article-list">
  <div class="wrapper wrapper-gutter-medium">
    <div class="row-group">
      <div class="column column-lg-12">
        <?php if ($select_article_list_title) { ?>
            <div class="theme-section-header">
              <h2 class="theme-header-title">
                <?php echo esc_html($select_article_list_title); ?>
              </h2>
            </div>
        <?php } ?>

        <div class="article-list-swiper swiper">
          <div class="swiper-wrapper">
            <?php
            $article_list_args_1 = array(
                'post_type' => 'post',
                'posts_per_page' => 5,
                'post_status' => 'publish',
                'no_found_rows' => 1,
                'ignore_sticky_posts' => 1,
            );
            // Check for category.
            if (!empty($article_list_post_category)) :
                $article_list_args_1['tax_query'] = array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $article_list_post_category,
                    ),
                );
            endif;
            $count = 1;
            $article_list_post_1 = new WP_Query($article_list_args_1);
            if ($article_list_post_1->have_posts()) :
                while ($article_list_post_1->have_posts()) :
                    $article_list_post_1->the_post(); ?>
                    <div class="swiper-slide">
                      <article id="article-list-<?php the_ID(); ?>" <?php post_class('wpi-post'); ?>>
                        <?php if ($article_list_post_video_on) { ?>
                            <div class="content-has-video">
                              <?php 
                              $content = get_the_content();
                                  if (has_block('core/video', $content)) {
                                      reelcraft_instance_of_block('core/video', $content);
                                  } elseif (has_block('core/embed', $content)) {
                                      reelcraft_instance_of_block('core/embed', $content);
                                  }
                                    reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                              ?>
                            </div>
                        <?php } else {
                            reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                        } ?>
    
                        <div class="entry-details">
                            <?php
                            if ($enable_article_list_category_meta) {
                                reelcraft_post_category($select_article_list_category_color, $article_list_category_label, $select_article_list_number_of_category);
                            }
                            ?>
                            <h3 class="entry-title entry-title-small">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            <div class="entry-meta-wrapper">
    
                                <?php
                                if ($enable_article_list_date_meta) {
                                    reelcraft_posted_on($select_article_list_date_format, $select_article_list_date_meta_title, $select_article_list_date);
                                }
                                ?>
    
                                <?php
                                if ($enable_article_list_author_meta) {
                                    reelcraft_posted_by($select_article_list_author_meta, $article_list_author_meta_title);
                                }
                                ?>
    
                            </div>
                        </div>
                      </article>
                    </div>
                  <?php
                  endwhile;
                wp_reset_postdata();
              endif; ?>
          </div>

          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
      </div>
    </div>
  </div>
</section>
