<?php
/**
 * Implements the compatibility for the Elementor plugin in Reelcraft theme.
 *
 * @package    Reelcraft
 * @since      Reelcraft 1.0.0
 */

use elementor\widgets\Reelcraft_Elementor_Global_Widgets_Title;
use elementor\widgets\Reelcraft_Elementor_Widgets_Block_1;
use elementor\widgets\Reelcraft_Elementor_Widgets_Block_2;
use elementor\widgets\Reelcraft_Elementor_Widgets_Block_3;
use elementor\widgets\Reelcraft_Elementor_Widgets_Block_4;
use elementor\widgets\Reelcraft_Elementor_Widgets_Block_5;
use elementor\widgets\Reelcraft_Elementor_Widgets_Grid_1;
use elementor\widgets\Reelcraft_Elementor_Widgets_Grid_2;
use elementor\widgets\Reelcraft_Elementor_Widgets_Grid_3;
use elementor\widgets\Reelcraft_Elementor_Widgets_Grid_4;
use elementor\widgets\Reelcraft_Elementor_Widgets_Grid_5;

/**
 * Load the Reelcraft Elementor widgets file and registers it
 */
if ( ! function_exists( 'reelcraft_elementor_widgets_registered' ) ) :

	/**
	 * Load and register the required Elementor widgets file.
	 *
	 * @param Elementor\Widgets_Manager $widgets_manager The widgets manager instance.
	 *
	 * @since Reelcraft 1.0.0
	 */
	function reelcraft_elementor_widgets_registered( $widgets_manager ) {

		// Require the Widget Base class.
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/class-reelcraft-elementor-widget-base.php';

		// Require the files.
		// 1. Block Widgets.
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-block-1.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-block-2.php';
        require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-block-3.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-block-4.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-block-5.php';

		// 2. Grid Widgets.
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-grid-1.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-grid-2.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-grid-3.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-grid-4.php';
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-widgets-grid-5.php';

		// 3. Global Widgets.
		require get_template_directory()  . '/inc/compatibility/elementor/widgets/reelcraft-elementor-global-widgets-title.php';

		// Register the widgets
		// 1. Block Widgets.
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Block_1() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Block_2() );
        $widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Block_3() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Block_4() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Block_5() );

		// 2. Grid Widgets.
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Grid_1() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Grid_2() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Grid_3() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Grid_4() );
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Widgets_Grid_5() );

		// 3. Global Widgets.
		$widgets_manager->register_widget_type( new Reelcraft_Elementor_Global_Widgets_Title() );

	}

endif;

add_action( 'elementor/widgets/widgets_registered', 'reelcraft_elementor_widgets_registered' );

if ( ! function_exists( 'reelcraft_elementor_category' ) ) :

	/**
	 * Add the Elementor category for use in Reelcraft widgets as separator.
	 *
	 * @since Reelcraft 1.0.0
	 */
	function reelcraft_elementor_category() {

		// Register widget block category for Elementor section.
		\Elementor\Plugin::instance()->elements_manager->add_category(
			'reelcraft-widget-blocks',
			array(
				'title' => esc_html__( 'Reelcraft Widget Blocks', 'reelcraft' ),
			),
			1
		);

		// Register widget grid category for Elementor section.
		\Elementor\Plugin::instance()->elements_manager->add_category(
			'reelcraft-widget-grid',
			array(
				'title' => esc_html__( 'Reelcraft Widget Grid', 'reelcraft' ),
			),
			1
		);

		// Register widget global category for Elementor section.
		\Elementor\Plugin::instance()->elements_manager->add_category(
			'reelcraft-widget-global',
			array(
				'title' => esc_html__( 'Reelcraft Global Widgets', 'reelcraft' ),
			),
			1
		);
	}

endif;

add_action( 'elementor/init', 'reelcraft_elementor_category' );

if ( ! function_exists( 'reelcraft_elementor_enqueue_style' ) ) :

	/**
	 * Enqueue the styles for use within Elementor only.
	 *
	 * @since Reelcraft 1.0.0
	 */
	function reelcraft_elementor_enqueue_style() {

		$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		// Enqueue the main Elementor CSS file for use with Elementor.
        wp_enqueue_style(
            'reelcraft-elementor', get_template_directory_uri() . '/inc/compatibility/elementor/assets/css/elementor' . $suffix . '.css', array(), REELCRAFT_VERSION);

        wp_style_add_data( 'reelcraft-elementor', 'rtl', 'replace' );

	}

endif;

add_action( 'elementor/frontend/after_enqueue_styles', 'reelcraft_elementor_enqueue_style' );
