<?php
$wp_customize->add_section(
	'sidebar_options',
	array(
		'title' => esc_html__( 'SideBar Options', 'reelcraft' ),
		'panel' => 'archive_options_panel',
	)
);

$wp_customize->add_setting(
    'reelcraft_options[sidebar_layout_option]',
    array(
        'default'           => $reelcraft_default['sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'reelcraft_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Reelcraft_Custom_Radio_Image_Control(
        $wp_customize,
        'reelcraft_options[sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (archive)', 'reelcraft' ),
            'section'       => 'sidebar_options',
            'choices'       => reelcraft_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[single_sidebar_layout_option]',
    array(
        'default'           => $reelcraft_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'reelcraft_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Reelcraft_Custom_Radio_Image_Control(
        $wp_customize,
        'reelcraft_options[single_sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'reelcraft' ),
            'section'       => 'sidebar_options',
            'choices'       => reelcraft_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[enable_sidebar_fix_archive]',
    array(
        'default'           => $reelcraft_default['enable_sidebar_fix_archive'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_sidebar_fix_archive]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'reelcraft' ),
        'section'     => 'sidebar_options',
        'type'        => 'checkbox',
    )
);
