<?php
$wp_customize->add_section(
    'single_author_options',
    array(
        'title' => esc_html__( 'Single Author Post Options', 'reelcraft' ),
        'panel' => 'single_options_panel',
    )
);
/*Show Author Posts
*-----------------------------------------*/
$wp_customize->add_setting(
    'reelcraft_options[show_author_posts]',
    array(
        'default'           => $reelcraft_default['show_author_posts'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[show_author_posts]',
    array(
        'label'    => __( 'Show Author Posts', 'reelcraft' ),
        'section'  => 'single_author_options',
        'type'     => 'checkbox',
    )
);

/*Author Posts Text.*/
$wp_customize->add_setting(
    'reelcraft_options[author_posts_text]',
    array(
        'default'           => $reelcraft_default['author_posts_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[author_posts_text]',
    array(
        'label'    => __( 'Author Posts Text', 'reelcraft' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

/* Number of Author Posts */
$wp_customize->add_setting(
    'reelcraft_options[no_of_author_posts]',
    array(
        'default'           => $reelcraft_default['no_of_author_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[no_of_author_posts]',
    array(
        'label'       => __( 'Number of Author Posts', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'number',
    )
);

/*Author Posts Orderby*/
$wp_customize->add_setting(
    'reelcraft_options[author_posts_orderby]',
    array(
        'default'           => $reelcraft_default['author_posts_orderby'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[author_posts_orderby]',
    array(
        'label'       => __( 'Orderby', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'date' => __('Date', 'reelcraft'),
            'id' => __('ID', 'reelcraft'),
            'title' => __('Title', 'reelcraft'),
            'rand' => __('Random', 'reelcraft'),
        ),
    )
);

/*Author Posts Order*/
$wp_customize->add_setting(
    'reelcraft_options[author_posts_order]',
    array(
        'default'           => $reelcraft_default['author_posts_order'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[author_posts_order]',
    array(
        'label'       => __( 'Order', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'asc' => __('ASC', 'reelcraft'),
            'desc' => __('DESC', 'reelcraft'),
        ),
    )
);



$wp_customize->add_setting(
    'reelcraft_options[enable_author_posts_author_meta]',
    array(
        'default'           => $reelcraft_default['enable_author_posts_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_author_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_posts_author_meta]',
    array(
        'default'           => $reelcraft_default['select_author_posts_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => reelcraft_author_meta(),


    )
);

$wp_customize->add_setting(
    'reelcraft_options[author_posts_author_meta_title]',
    array(
        'default'           => $reelcraft_default['author_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[author_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'reelcraft' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_author_posts_date_meta]',
    array(
        'default'           => $reelcraft_default['enable_author_posts_date_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_author_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_posts_date]',
    array(
        'default'           => $reelcraft_default['select_author_posts_date'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_posts_date]',
    array(
        'label'         => esc_html__( 'Select Single Date Meta', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => reelcraft_date_meta(),

    )
);

$wp_customize->add_setting(
    'reelcraft_options[single_related_post_date_meta_title]',
    array(
        'default'           => $reelcraft_default['single_related_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[single_related_post_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'reelcraft' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_posts_date_format]',
    array(
        'default'           => $reelcraft_default['select_author_posts_date_format'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => reelcraft_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_author_posts_category_meta]',
    array(
        'default'           => $reelcraft_default['enable_author_posts_category_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_author_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_posts_number_of_category]',
    array(
        'default'           => $reelcraft_default['select_author_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'reelcraft' ),
        'section'     => 'single_related_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[author_posts_category_label]',
    array(
        'default'           => $reelcraft_default['author_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[author_posts_category_label]',
    array(
        'label'    => __( 'Category Label', 'reelcraft' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_posts_category_color]',
    array(
        'default'           => $reelcraft_default['select_author_posts_category_color'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'reelcraft' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => reelcraft_category_color(),

    )
);
