<?php
/**
 * All settings related to preloader.
 *
 * @package Reelcraft
 */
$wp_customize->add_section(
	'preloader_options',
	array(
		'title' => esc_html__( 'Preloader Options', 'reelcraft' ),
		'panel' => 'general_options_panel',
	)
);

$wp_customize->add_setting(
    'reelcraft_options[enable_preloader_options]',
    array(
        'default'           => $reelcraft_default['enable_preloader_options'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_preloader_options]',
    array(
        'label'       => esc_html__( 'Enable Preloader Option', 'reelcraft' ),
        'section'     => 'preloader_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[reelcraft_preloader_style]',
    array(
        'default'           => $reelcraft_default['reelcraft_preloader_style'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[reelcraft_preloader_style]',
    array(
        'label'         => esc_html__( 'Select Preloader Style', 'reelcraft' ),
        'section'     => 'preloader_options',
        'type'        => 'select',
        'choices'       => reelcraft_preloader_style_option(),

    )
);
