<?php
$wp_customize->add_section(
   'mobile_menu_options' ,
    array(
        'title' => __( 'Mobile Menu Options', 'reelcraft' ),
        'panel' => 'header_options_panel',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_social_mobile_menu]',
    array(
        'default'           => $reelcraft_default['enable_social_mobile_menu'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_social_mobile_menu]',
    array(
        'label'         => esc_html__( 'Social Menu to Display in Mobile', 'reelcraft' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_mobile_social_menu_style]',
    array(
        'default'           => $reelcraft_default['select_mobile_social_menu_style'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_mobile_social_menu_style]',
    array(
        'label'         => esc_html__( 'Social Menu Options', 'reelcraft' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'select',
        'choices'       => reelcraft_social_menu_style(),


    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_mobile_social_nav_border_radius]',
    array(
        'default'           => $reelcraft_default['enable_mobile_social_nav_border_radius'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_mobile_social_nav_border_radius]',
    array(
        'label'    => __( 'Enable Border Radius', 'reelcraft' ),
        'section'  => 'mobile_menu_options',
        'type'     => 'checkbox',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[enable_copyright_in_menu]',
    array(
        'default'           => $reelcraft_default['enable_copyright_in_menu'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_copyright_in_menu]',
    array(
        'label'         => esc_html__( 'Copyright in Mobile', 'reelcraft' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_section(
   'streaming_button_options' ,
    array(
        'title' => __( 'Streaming Options', 'reelcraft' ),
        'panel' => 'header_options_panel',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_streaming_button]',
    array(
        'default'           => $reelcraft_default['enable_streaming_button'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_streaming_button]',
    array(
        'label'         => esc_html__( 'Enable Streaming Button', 'reelcraft' ),
        'section'     => 'streaming_button_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[streaming_button_text]',
    array(
        'default'           => $reelcraft_default['streaming_button_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[streaming_button_text]',
    array(
        'label'    => __( 'Streaming Button Text', 'reelcraft' ),
        'section'  => 'streaming_button_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[streaming_button_url]',
    array(
        'default'           => $reelcraft_default['streaming_button_url'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    'reelcraft_options[streaming_button_url]',
    array(
        'label'    => __( 'Streaming Button URL', 'reelcraft' ),
        'section'  => 'streaming_button_options',
        'type'     => 'text',
    )
);
