<?php
$wp_customize->add_section(
   'header_style_options' ,
    array(
        'title' => __( 'Header style Option', 'reelcraft' ),
        'panel' => 'header_options_panel',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[select_header_layout_style]',
    array(
        'default'           => $reelcraft_default['select_header_layout_style'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'reelcraft_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Reelcraft_Custom_Radio_Image_Control(
        $wp_customize,
        'reelcraft_options[select_header_layout_style]',
        array(
            'label'         => esc_html__( 'Select Header Layout', 'reelcraft' ),
            'section'       => 'header_style_options',
            'choices'       => reelcraft_get_header_layout(),
        )
    )
);