<?php
// footer widget Options.
$wp_customize->add_section(
    'footer_widget_section',
    array(
        'title' => __('Footer Widget Options', 'reelcraft'),
        'panel' => 'footer_options_panel',
    )
);



/*Enable Footer Nav*/
$wp_customize->add_setting(
    'reelcraft_options[enable_footer_widget]',
    array(
        'default'           => $reelcraft_default['enable_footer_widget'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_footer_widget]',
    array(
        'label'       => __( 'Show Footer widgetarea', 'reelcraft' ),
        'section'     => 'footer_widget_section',
        'type'     => 'checkbox',
    )
);

// Option to choose footer column layout.
$wp_customize->add_setting(
	'reelcraft_options[footer_column_layout]',
	array(
		'default'           => $reelcraft_default['footer_column_layout'],
		'sanitize_callback' => 'reelcraft_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Reelcraft_Custom_Radio_Image_Control(
		$wp_customize,
		'reelcraft_options[footer_column_layout]',
		array(
			'label'       => __( 'Footer Column Layout', 'reelcraft' ),
			'description' => __( 'Some footer widgetareas will not be used based on the footer column layout chosen. Also make sure to insert at least one widget on the respective widgetarea for it to display.', 'reelcraft' ),
			'section'     => 'footer_widget_section',
			'choices'     => reelcraft_get_footer_layouts(),
			'priority'    => 40,
		)
	)
);
