<?php
/**
 * All settings related to footer recommended post.
 *
 * @package Reelcraft
 */
$wp_customize->add_section(
	'footer_recommended_post',
	array(
		'title' => esc_html__( 'Recommended Section', 'reelcraft' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'reelcraft_options[enable_recommended_post]',
    array(
        'default'           => $reelcraft_default['enable_recommended_post'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_recommended_post]',
    array(
        'label'       => esc_html__( 'Enable Recommended Post', 'reelcraft' ),
        'section'     => 'footer_recommended_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[recommended_post_layout]',
    array(
        'default'           => $reelcraft_default['recommended_post_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'reelcraft_sanitize_radio'
    )
);


$wp_customize->add_control(
    new Reelcraft_Custom_Radio_Image_Control(
        $wp_customize,
        'reelcraft_options[recommended_post_layout]',
        array(
            'label'         => esc_html__( 'Recommended Post Layout', 'reelcraft' ),
            'section'       => 'footer_recommended_post',
            'choices'       => reelcraft_get_recommended_post(),
        )
    )
);



$wp_customize->add_setting(
    'reelcraft_options[recommended_post_title]',
    array(
        'default'           => $reelcraft_default['recommended_post_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[recommended_post_title]',
    array(
        'label'    => __( 'Recommended Post', 'reelcraft' ),
        'section'  => 'footer_recommended_post',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[recommended_post_category]',
    array(
        'default'           => $reelcraft_default['recommended_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Reelcraft_Dropdown_Taxonomies_Control(
        $wp_customize,
        'reelcraft_options[recommended_post_category]',
        array(
            'label'           => __( 'Choose Category', 'reelcraft' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'reelcraft' ),
            'section'         => 'footer_recommended_post',
        )
    )
);









$wp_customize->add_setting(
    'reelcraft_options[enable_recommended_post_author_meta]',
    array(
        'default' => $reelcraft_default['enable_recommended_post_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_author_meta]',
    array(
        'default' => $reelcraft_default['select_recommended_post_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => reelcraft_author_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[recommended_post_author_meta_title]',
    array(
        'default' => $reelcraft_default['recommended_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[recommended_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_recommended_post_date_meta]',
    array(
        'default' => $reelcraft_default['enable_recommended_post_date_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_recommended_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_date]',
    array(
        'default' => $reelcraft_default['select_recommended_post_date'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_date]',
    array(
        'label' => esc_html__('Select Single Date Meta', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => reelcraft_date_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_date_meta_title]',
    array(
        'default' => $reelcraft_default['select_recommended_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_date_meta_title]',
    array(
        'label' => __('Date Text', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_date_format]',
    array(
        'default' => $reelcraft_default['select_recommended_post_date_format'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => reelcraft_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_recommended_post_category_meta]',
    array(
        'default' => $reelcraft_default['enable_recommended_post_category_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_recommended_post_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_number_of_category]',
    array(
        'default' => $reelcraft_default['select_recommended_post_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_number_of_category]',
    array(
        'label' => __('Number of Category', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[recommended_post_category_label]',
    array(
        'default' => $reelcraft_default['recommended_post_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[recommended_post_category_label]',
    array(
        'label' => __('Category Label', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_recommended_post_category_color]',
    array(
        'default' => $reelcraft_default['select_recommended_post_category_color'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_recommended_post_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'reelcraft'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => reelcraft_category_color(),
    )
);