<?php
/**
 * All settings related to sports banner post.
 *
 * @package Reelcraft
 */
$wp_customize->add_section(
	'dual_category_post',
	array(
		'title' => esc_html__( 'Dual Category Section', 'reelcraft' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'reelcraft_options[enable_dual_cat_section]',
    array(
        'default'           => $reelcraft_default['enable_dual_cat_section'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_dual_cat_section]',
    array(
        'label'       => esc_html__( 'Enable Dual Category', 'reelcraft' ),
        'section'     => 'dual_category_post',
        'type'        => 'checkbox',
    )
);



$wp_customize->add_setting(
    'reelcraft_section_seperator_dual_cat_column_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Reelcraft_Seperator_Control(
        $wp_customize,
        'reelcraft_section_seperator_dual_cat_column_1',
        array(
            'label'         => esc_html__( 'Dual Category Slider', 'reelcraft' ),
            'settings' => 'reelcraft_section_seperator_dual_cat_column_1',
            'section' => 'dual_category_post',
        )
    )
);

$wp_customize->add_setting(
    'reelcraft_options[dual_category_post_title_1]',
    array(
        'default'           => $reelcraft_default['dual_category_post_title_1'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[dual_category_post_title_1]',
    array(
        'label'    => __( 'Section Title 1', 'reelcraft' ),
        'section'  => 'dual_category_post',
        'type'     => 'text',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[dual_category_post_category]',
    array(
        'default'           => $reelcraft_default['dual_category_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Reelcraft_Dropdown_Taxonomies_Control(
        $wp_customize,
        'reelcraft_options[dual_category_post_category]',
        array(
            'label'           => __( 'Choose Post Category 1', 'reelcraft' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'reelcraft' ),
            'section'         => 'dual_category_post',
        )
    )
);



$wp_customize->add_setting(
    'reelcraft_options[dual_category_post_video_on]',
    array(
        'default'           => $reelcraft_default['dual_category_post_video_on'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[dual_category_post_video_on]',
    array(
        'label'       => esc_html__( 'Enable Video On Image Hover', 'reelcraft' ),
        'section'     => 'dual_category_post',
        'type'        => 'checkbox',
    )
);





$wp_customize->add_setting(
    'reelcraft_section_seperator_dual_cat_column_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Reelcraft_Seperator_Control(
        $wp_customize,
        'reelcraft_section_seperator_dual_cat_column_2',
        array(
            'label'         => esc_html__( 'Dual Category Post', 'reelcraft' ),
            'settings' => 'reelcraft_section_seperator_dual_cat_column_2',
            'section' => 'dual_category_post',
        )
    )
);

$wp_customize->add_setting(
    'reelcraft_section_seperator_slider_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Reelcraft_Seperator_Control(
        $wp_customize,
        'reelcraft_section_seperator_slider_banner',
        array(
            'label'         => esc_html__( 'Dual Category Section Meta', 'reelcraft' ),
            'settings' => 'reelcraft_section_seperator_slider_banner',
            'section' => 'dual_category_post',
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[enable_dual_cat_author_meta]',
    array(
        'default' => $reelcraft_default['enable_dual_cat_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_dual_cat_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_author_meta]',
    array(
        'default' => $reelcraft_default['select_dual_cat_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'select',
        'choices' => reelcraft_author_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[dual_cat_author_meta_title]',
    array(
        'default' => $reelcraft_default['dual_cat_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[dual_cat_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_dual_cat_date_meta]',
    array(
        'default' => $reelcraft_default['enable_dual_cat_date_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_dual_cat_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_date]',
    array(
        'default' => $reelcraft_default['select_dual_cat_date'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_date]',
    array(
        'label' => esc_html__('Select Single Date Meta', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'select',
        'choices' => reelcraft_date_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_date_meta_title]',
    array(
        'default' => $reelcraft_default['select_dual_cat_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_date_meta_title]',
    array(
        'label' => __('Date Text', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_date_format]',
    array(
        'default' => $reelcraft_default['select_dual_cat_date_format'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'select',
        'choices' => reelcraft_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_dual_cat_category_meta]',
    array(
        'default' => $reelcraft_default['enable_dual_cat_category_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_dual_cat_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_number_of_category]',
    array(
        'default' => $reelcraft_default['select_dual_cat_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_number_of_category]',
    array(
        'label' => __('Number of Category', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[dual_cat_category_label]',
    array(
        'default' => $reelcraft_default['dual_cat_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[dual_cat_category_label]',
    array(
        'label' => __('Category Label', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_dual_cat_category_color]',
    array(
        'default' => $reelcraft_default['select_dual_cat_category_color'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_dual_cat_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'reelcraft'),
        'section' => 'dual_category_post',
        'type' => 'select',
        'choices' => reelcraft_category_color(),
    )
);