<?php
/**
 * All settings related to article list.
 *
 * @package Reelcraft
 */
$wp_customize->add_section(
	'article_list',
	array(
		'title' => esc_html__( 'Article List Section', 'reelcraft' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'reelcraft_options[enable_article_list_section]',
    array(
        'default'           => $reelcraft_default['enable_article_list_section'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_article_list_section]',
    array(
        'label'       => esc_html__( 'Enable Article List', 'reelcraft' ),
        'section'     => 'article_list',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_article_list_title]',
    array(
        'default' => $reelcraft_default['select_article_list_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_title]',
    array(
        'label' => __('Article Title Text', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[article_list_post_category]',
    array(
        'default'           => '',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Reelcraft_Dropdown_Taxonomies_Control(
        $wp_customize,
        'reelcraft_options[article_list_post_category]',
        array(
            'label'           => __( 'Choose Post Category', 'reelcraft' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'reelcraft' ),
            'section'         => 'article_list',
        )
    )
);

$wp_customize->add_setting(
    'reelcraft_options[article_list_post_video_on]',
    array(
        'default'           => $reelcraft_default['article_list_post_video_on'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[article_list_post_video_on]',
    array(
        'label'       => esc_html__( 'Enable Video On Image Hover', 'reelcraft' ),
        'section'     => 'article_list',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_section_seperator_article_list_column_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Reelcraft_Seperator_Control(
        $wp_customize,
        'reelcraft_section_seperator_article_list_column_1',
        array(
            'label'         => esc_html__( 'Article List', 'reelcraft' ),
            'settings' => 'reelcraft_section_seperator_article_list_column_1',
            'section' => 'article_list',
        )
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_article_list_author_meta]',
    array(
        'default' => $reelcraft_default['enable_article_list_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_article_list_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_article_list_author_meta]',
    array(
        'default' => $reelcraft_default['select_article_list_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'select',
        'choices' => reelcraft_author_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[article_list_author_meta_title]',
    array(
        'default' => $reelcraft_default['article_list_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[article_list_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_article_list_date_meta]',
    array(
        'default' => $reelcraft_default['enable_article_list_date_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_article_list_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_article_list_date]',
    array(
        'default' => $reelcraft_default['select_article_list_date'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_date]',
    array(
        'label' => esc_html__('Select Single Date Meta', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'select',
        'choices' => reelcraft_date_meta(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_article_list_date_meta_title]',
    array(
        'default' => $reelcraft_default['select_article_list_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_date_meta_title]',
    array(
        'label' => __('Date Text', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_article_list_date_format]',
    array(
        'default' => $reelcraft_default['select_article_list_date_format'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'select',
        'choices' => reelcraft_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'reelcraft_options[enable_article_list_category_meta]',
    array(
        'default' => $reelcraft_default['enable_article_list_category_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_article_list_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[select_article_list_number_of_category]',
    array(
        'default' => $reelcraft_default['select_article_list_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_number_of_category]',
    array(
        'label' => __('Number of Category', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'reelcraft_options[article_list_category_label]',
    array(
        'default' => $reelcraft_default['article_list_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[article_list_category_label]',
    array(
        'label' => __('Category Label', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_article_list_category_color]',
    array(
        'default' => $reelcraft_default['select_article_list_category_color'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_article_list_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'reelcraft'),
        'section' => 'article_list',
        'type' => 'select',
        'choices' => reelcraft_category_color(),
    )
);