<?php
if (!function_exists('reelcraft_get_option')) :
    /**
     * Get customizer value by key.
     *
     * @param string $key Option key.
     * @return mixed Option value.
     * @since 1.0.0
     *
     */
    function reelcraft_get_option($key)
    {
        $key_value = '';
        if (!$key) {
            return $key_value;
        }
        $default_values = reelcraft_get_all_customizer_default_values();
        $customizer_values = get_theme_mod('reelcraft_options');
        $customizer_values = wp_parse_args($customizer_values, $default_values);

        $key_value = (isset($customizer_values[$key])) ? $customizer_values[$key] : '';
        return $key_value;
    }
endif;

if ( ! function_exists( 'reelcraft_get_archive_layouts' ) ) :
	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_archive_layouts() {
		$options = apply_filters(
			'reelcraft_get_archive_layouts',
			array(
				'archive_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-1.webp',
					'label' => esc_html__( 'Archive List View', 'reelcraft' ),
				),
				'archive_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-2.webp',
					'label' => esc_html__( 'Archive Grid View', 'reelcraft' ),
				),
				'archive_style_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-3.webp',
					'label' => esc_html__( 'Archive Alternate Grid View', 'reelcraft' ),
				),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_get_date_formats' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_date_formats() {
		$options = apply_filters(
			'reelcraft_archive_date_format',
			array(
				'classic'   => __( 'Classic', 'reelcraft' ),
				'time_ago' => __( 'Time Ago', 'reelcraft' ),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_line_limit_choices' ) ) :
	/**
	 * Returns title limit options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_line_limit_choices() {
		$options = apply_filters(
			'reelcraft_title_limit_options',
			array(
				''              => __( '&mdash; No Limit &mdash;', 'reelcraft' ),
				'limit-line-1' => __( '1 Line', 'reelcraft' ),
				'limit-line-2' => __( '2 Lines', 'reelcraft' ),
				'limit-line-3' => __( '3 Lines', 'reelcraft' ),
				'limit-line-4' => __( '4 Lines', 'reelcraft' ),
				'limit-line-5' => __( '5 Lines', 'reelcraft' ),
			)
		);
		return $options;
	}
endif;
if ( ! function_exists( 'reelcraft_archive_category_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_archive_category_style() {
		$options = apply_filters(
			'reelcraft_archive_category_style',
			array(
				'archive_cat_style_1'   => __( 'Category Style 1', 'reelcraft' ),
				'archive_cat_style_2'   => __( 'Category Style 2', 'reelcraft' ),
				'archive_cat_style_3'   => __( 'Category Style 3', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_archive_read_time_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_archive_read_time_style() {
		$options = apply_filters(
			'reelcraft_archive_read_time_style',
			array(
				'archive_read_time_style_1'   => __( 'Read Time Style 1', 'reelcraft' ),
				'archive_read_time_style_2'   => __( 'Read Time Style 2', 'reelcraft' ),
				'archive_read_time_style_3'   => __( 'Read Time Style 3', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_get_header_layout' ) ) :
	/**
	 * Returns header layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_header_layout() {
		$options = apply_filters(
			'reelcraft_get_header_layout',
			array(
				'header_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-1.webp',
					'label' => esc_html__( 'Header Style 1', 'reelcraft' ),
				),
		        'header_style_4' => array(
		            'url'   => get_template_directory_uri() . '/assets/images/header-4.webp',
		            'label' => esc_html__( 'Header Style 4', 'reelcraft' ),
		        ),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_social_menu_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_social_menu_style() {
		$options = apply_filters(
			'reelcraft_social_menu_style',
			array(
				'has-brand-background'   => __( 'Has Brand Background', 'reelcraft' ),
				'has-brand-color'   => __( 'Has Brand Color', 'reelcraft' ),
				'none'   => __( 'None', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_pagination_style_choice' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_pagination_style_choice() {
		$options = apply_filters(
			'reelcraft_pagination_style_choice',
			array(
				'pagination_none'   => __( 'None', 'reelcraft' ),
				'pagination_numeric'   => __( 'Numeric', 'reelcraft' ),
				'pagination_default'   => __( 'Default(New/Old Post)', 'reelcraft' ),
				'pagination_ajax_on_scroll'   => __( 'Load More On Scroll', 'reelcraft' ),
				'pagination_ajax_on_click'   => __( 'Load More On Click', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_category_color' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_category_color() {
		$options = apply_filters(
			'reelcraft_category_color',
			array(
				'none'   => __( 'None', 'reelcraft' ),
				'has-background'   => __( 'Has dot', 'reelcraft' ),
				'has-text-color'   => __( 'Has text color', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_get_footer_layouts' ) ) :
	/**
	 * Returns footer layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_footer_layouts() {
		$options = apply_filters(
			'reelcraft_footer_layouts',
			array(
				'footer_layout_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-4.webp',
					'label' => esc_html__( 'Four Columns', 'reelcraft' ),
				),
				'footer_layout_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3.webp',
					'label' => esc_html__( 'Three Columns', 'reelcraft' ),
				),
				'footer_layout_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2.webp',
					'label' => esc_html__( 'Two Columns', 'reelcraft' ),
				),
				'footer_layout_4' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-left.webp',
					'label' => esc_html__( 'Two Columns Big Left', 'reelcraft' ),
				),
				'footer_layout_5' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3-big-middle.webp',
					'label' => esc_html__( 'Three Columns Big Middle', 'reelcraft' ),
				),
				'footer_layout_6' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-right.webp',
					'label' => esc_html__( 'Two Columns Big Right', 'reelcraft' ),
				),
				'footer_layout_7' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-1.webp',
					'label' => esc_html__( 'Single Column', 'reelcraft' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_preloader_style_option' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_preloader_style_option() {
		$options = apply_filters(
			'reelcraft_preloader_style_option',
			array(
				'style-1'   => __( 'Style - 1', 'reelcraft' ),
				'style-2'   => __( 'Style - 2', 'reelcraft' ),
				'style-3'   => __( 'Style - 3', 'reelcraft' ),
				'style-4'   => __( 'Style - 4', 'reelcraft' ),
				'style-5'   => __( 'Style - 5', 'reelcraft' ),
				'style-6'   => __( 'Style - 6', 'reelcraft' ),
				'style-7'   => __( 'Style - 7', 'reelcraft' ),
				'style-8'   => __( 'Style - 8', 'reelcraft' ),
				'style-9'   => __( 'Style - 9', 'reelcraft' ),
				'style-10'   => __( 'Style - 10', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_get_recommended_post' ) ) :
	/**
	 * Returns recommended layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_recommended_post() {
		$options = apply_filters(
			'reelcraft_get_recommended_post',
			array(
				'wpi-post-recommendation-1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-1.webp',
					'label' => esc_html__( 'Recommended List View', 'reelcraft' ),
				),
				'wpi-post-recommendation-2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-2.webp',
					'label' => esc_html__( 'Recommended Grid View', 'reelcraft' ),
				),
				'wpi-post-recommendation-3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-3.webp',
					'label' => esc_html__( 'Recommended Alternate Grid View', 'reelcraft' ),
				),
			)
		);
		return $options;
	}
endif;



if ( ! function_exists( 'reelcraft_author_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_author_meta() {
		$options = apply_filters(
			'reelcraft_author_meta',
			array(
				'with_label'   => __( 'With Label', 'reelcraft' ),
				'with_icon'   => __( 'With Icon', 'reelcraft' ),
				'with_avatar_image'   => __( 'With Avatar Image', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_date_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_date_meta() {
		$options = apply_filters(
			'reelcraft_date_meta',
			array(
				'with_label'   => __( 'With Label', 'reelcraft' ),
				'with_icon'   => __( 'With Icon', 'reelcraft' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'reelcraft_get_sidebar_layouts' ) ) :
	/**
	 * Returns general layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_sidebar_layouts() {
		$options = apply_filters(
			'reelcraft_sidebar_layouts',
			array(
				'left-sidebar'      => array(
					'url'   => get_template_directory_uri() . '/assets/images/left-sidebar.webp',
					'label' => esc_html__( 'Left Sidebar', 'reelcraft' ),
				),
				'right-sidebar'     => array(
					'url'   => get_template_directory_uri() . '/assets/images/right-sidebar.webp',
					'label' => esc_html__( 'Right Sidebar', 'reelcraft' ),
				),
				'no-sidebar'        => array(
					'url'   => get_template_directory_uri() . '/assets/images/no-sidebar.webp',
					'label' => esc_html__( 'No Sidebar - Wide', 'reelcraft' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'reelcraft_get_social_links_styles' ) ) :
	/**
	 * Returns social links styles options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function reelcraft_get_social_links_styles() {
		$options = apply_filters(
			'reelcraft_social_links_styles',
			array(
				'style_1' => __( 'Style 1', 'reelcraft' ),
				'style_2' => __( 'Style 2', 'reelcraft' ),
				'style_3' => __( 'Style 3', 'reelcraft' ),
				'style_4' => __( 'Style 4', 'reelcraft' ),
			)
		);
		return $options;
	}
endif;
