<?php
/**
 * The front page template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Reelcraft
 */
get_header();
if ('posts' == get_option('show_on_front')) {

    if (!is_paged() && is_front_page()) {
        
        
        get_template_part('template-parts/section/main-banner');
        get_template_part('template-parts/section/featured-category');
        get_template_part('template-parts/section/article-list');
        get_template_part('template-parts/section/dual-category');
        get_template_part('template-parts/section/highlight-cat-post');
        get_template_part('template-parts/section/featured-block');
        get_template_part('template-parts/section/spotlight-section');
        get_template_part('template-parts/section/theme-latest-post');
        get_template_part('template-parts/widgetarea/homepage-fullwidth-top');
        get_template_part('template-parts/widgetarea/homepage-two-column');
        get_template_part('template-parts/widgetarea/homepage-fullwidth-bottom');
    }
    $enable_latest_post = reelcraft_get_option('enable_latest_post');
    if ($enable_latest_post) {
        include get_home_template();
    }
} else {
        get_template_part('template-parts/section/main-banner');
        get_template_part('template-parts/section/featured-category');
        get_template_part('template-parts/section/article-list');
        get_template_part('template-parts/section/dual-category');
        get_template_part('template-parts/section/highlight-cat-post');
        get_template_part('template-parts/section/featured-block');
        get_template_part('template-parts/section/spotlight-section');
        get_template_part('template-parts/section/theme-latest-post');

    if (!is_paged() && is_front_page()) {
        get_template_part('template-parts/widgetarea/homepage-fullwidth-top');
        get_template_part('template-parts/widgetarea/homepage-two-column');
        get_template_part('template-parts/widgetarea/homepage-fullwidth-bottom');
    }

    do_action('reelcraft_home_before_widget_area');
    ?>
    <?php
    $enable_latest_post = reelcraft_get_option('enable_latest_post');
    if ($enable_latest_post) { ?>
        <main id="site-content" class="wpi-section" role="main">
            <div class="wrapper wrapper-gutter-medium">
                <div class="row-group">
                    <div id="primary" class="primary-area">
                        <div class="article-groups <?php echo esc_attr($archive_layout); ?>">
                            <?php
                            if (have_posts()) :
                                /* Start the Loop */
                                while (have_posts()) :
                                    the_post();
                                    /*
                                     * Include the Post-Type-specific template for the content.
                                     * If you want to override this in a child theme, then include a file
                                     * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                                     */
                                    get_template_part('template-parts/archive/archive', 'content');
                                endwhile;

                            else :
                                get_template_part('template-parts/content', 'none');
                            endif;
                            ?>
                        </div>
                        <?php
                        reelcraft_pagination_style();
                        ?>
                    </div>
                    <?php
                    get_sidebar();
                    ?>
                </div>
            </div>
        </main><!-- #main -->
    <?php } ?>
    <?php
    if (!is_paged() && is_front_page()) {
        get_template_part('template-parts/footer/footer-recomended');
    }
}

get_footer();
