<?php
$enable_spotlight_section = reelcraft_get_option('enable_spotlight_section');
$spotlight_post_video_on = reelcraft_get_option('spotlight_post_video_on');
$spotlight_post_title_1 = reelcraft_get_option('spotlight_post_title_1');
$spotlight_post_category_1 = reelcraft_get_option('spotlight_post_category_1');
$spotlight_post_category_2 = reelcraft_get_option('spotlight_post_category_2');

$enable_spotlight_author_meta = reelcraft_get_option('enable_spotlight_author_meta');
$select_spotlight_author_meta = reelcraft_get_option('select_spotlight_author_meta');
$spotlight_author_meta_title = reelcraft_get_option('spotlight_author_meta_title');

$enable_spotlight_date_meta = reelcraft_get_option('enable_spotlight_date_meta');
$select_spotlight_date = reelcraft_get_option('select_spotlight_date');
$select_spotlight_date_meta_title = reelcraft_get_option('select_spotlight_date_meta_title');
$select_spotlight_date_format = reelcraft_get_option('select_spotlight_date_format');

$enable_spotlight_category_meta = reelcraft_get_option('enable_spotlight_category_meta');
$spotlight_category_label = reelcraft_get_option('spotlight_category_label');
$select_spotlight_category_color = reelcraft_get_option('select_spotlight_category_color');
$select_spotlight_number_of_category = reelcraft_get_option('select_spotlight_number_of_category');
if (empty($enable_spotlight_section)) {
    return;
}
$archive_image_class = 'entry-image-large';
$archive_image_size = '';
?>
<section class="wpi-section theme-spotlight-section">
  <div class="wrapper wrapper-gutter-medium">
    <div class="row-group">
      <div class="column column-lg-12">
        <?php if ($spotlight_post_title_1) { ?>
          <header class="theme-section-header">
            <h2 class="theme-header-title"><?php echo esc_html($spotlight_post_title_1); ?></h2>
          </header>
        <?php } ?>
      </div>
    </div>
  </div>

  <div class="spotlight-content-wrapper swiper">
    <div class="swiper-wrapper">
      <?php
        $spotlight_args_1 = array(
            'post_type' => 'post',
            'posts_per_page' => 8,
            'post_status' => 'publish',
            'no_found_rows' => 1,
            'ignore_sticky_posts' => 1,
        );
        // Check for category.
        if (!empty($spotlight_post_category_1)) :
            $spotlight_args_1['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $spotlight_post_category_1,
                ),
            );
        endif;
        $spotlight_post_1 = new WP_Query($spotlight_args_1);
        if ($spotlight_post_1->have_posts()) :
            while ($spotlight_post_1->have_posts()) :
                $spotlight_post_1->the_post(); ?>
                <div class="swiper-slide">
                  <article id="spotlight-<?php the_ID(); ?>" class="wpi-post">
                    <?php if ($spotlight_post_video_on) { ?>
                        <div class="content-has-video">
                          <?php 
                          $content = get_the_content();
                              if (has_block('core/video', $content)) {
                                  reelcraft_instance_of_block('core/video', $content);
                              } elseif (has_block('core/embed', $content)) {
                                  reelcraft_instance_of_block('core/embed', $content);
                              }
                                reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                          ?>
                        </div>
                    <?php } else {
                        reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                    } ?>
                    <div class="entry-details">
                        <?php
                        if ($enable_spotlight_category_meta) {
                            reelcraft_post_category($select_spotlight_category_color, $spotlight_category_label, $select_spotlight_number_of_category);
                        }
                        ?>
                        <h3 class="entry-title entry-title-medium">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h3>
                        <div class="entry-meta-wrapper">

                            <?php
                            if ($enable_spotlight_date_meta) {
                                reelcraft_posted_on($select_spotlight_date_format, $select_spotlight_date_meta_title, $select_spotlight_date);
                            }
                            ?>

                            <?php
                            if ($enable_spotlight_author_meta) {
                                reelcraft_posted_by($select_spotlight_author_meta, $spotlight_author_meta_title);
                            }
                            ?>

                        </div>
                    </div>
                  </article>
                </div>
            <?php
            endwhile;
          wp_reset_postdata();
        endif;
      ?>
    </div>

    <div class="swiper-button-prev"></div>
    <div class="swiper-button-next"></div>
  </div>
</section>