<?php
$enable_cat_highlight_section = reelcraft_get_option('enable_cat_highlight_section');
$cat_highlight_post_title = reelcraft_get_option('cat_highlight_post_title');
$cat_highlight_post_category = reelcraft_get_option('cat_highlight_post_category');

$enable_cat_highlight_author_meta = reelcraft_get_option('enable_cat_highlight_author_meta');
$select_cat_highlight_author_meta = reelcraft_get_option('select_cat_highlight_author_meta');
$cat_highlight_author_meta_title = reelcraft_get_option('cat_highlight_author_meta_title');

$enable_cat_highlight_date_meta = reelcraft_get_option('enable_cat_highlight_date_meta');
$select_cat_highlight_date = reelcraft_get_option('select_cat_highlight_date');
$select_cat_highlight_date_meta_title = reelcraft_get_option('select_cat_highlight_date_meta_title');
$select_cat_highlight_date_format = reelcraft_get_option('select_cat_highlight_date_format');

$enable_cat_highlight_category_meta = reelcraft_get_option('enable_cat_highlight_category_meta');
$cat_highlight_category_label = reelcraft_get_option('cat_highlight_category_label');
$select_cat_highlight_category_color = reelcraft_get_option('select_cat_highlight_category_color');
$select_cat_highlight_number_of_category = reelcraft_get_option('select_cat_highlight_number_of_category');
if (empty($enable_cat_highlight_section)) {
    return;
}
?>
<section class="wpi-section theme-highlight-feed custom-swiper-pagination">
  <div class="wrapper wrapper-gutter-medium">
    <div class="row-group">
      <div class="column columnlg-12">
        <?php if ($cat_highlight_post_title) { ?>
          <header class="theme-section-header">
            <h2 class="theme-header-title"><?php echo esc_html($cat_highlight_post_title); ?></h2>
          </header>
        <?php } ?>
          <divd class="highlight-feed-slider swiper">
            <div class="swiper-wrapper">
              <?php
              $cat_highlight_args_1 = array(
                  'post_type' => 'post',
                  'posts_per_page' => 4,
                  'post_status' => 'publish',
                  'no_found_rows' => 1,
                  'ignore_sticky_posts' => 1,
              );
              // Check for category.
              if (!empty($cat_highlight_post_category)) :
                  $cat_highlight_args_1['tax_query'] = array(
                      array(
                          'taxonomy' => 'category',
                          'field' => 'term_id',
                          'terms' => $cat_highlight_post_category,
                      ),
                  );
              endif;
              $cat_highlight_post_1 = new WP_Query($cat_highlight_args_1);
              if ($cat_highlight_post_1->have_posts()) :
                  while ($cat_highlight_post_1->have_posts()) :
                      $cat_highlight_post_1->the_post(); ?>
                      <div class="swiper-slide">
                        <article id="highlight-feed-<?php the_ID(); ?>" class="wpi-post">
                          <?php if (has_post_thumbnail()) : ?>
                              <div class="entry-image">
                                  <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true"
                                      tabindex="-1">
                                      <?php
                                      the_post_thumbnail(
                                          'medium_large',
                                          array(
                                              'alt' => the_title_attribute(
                                                  array(
                                                      'echo' => false,
                                                  )
                                              ),
                                          )
                                      );
                                      ?>
                                  </a>
                              </div>
                          <?php endif; ?>

                          <div class="entry-details">
                            <div class="entry-details-content">
                              <?php
                              if ($enable_cat_highlight_category_meta) {
                                  reelcraft_post_category($select_cat_highlight_category_color, $cat_highlight_category_label, $select_cat_highlight_number_of_category);
                              }
                              ?>
                              <h3 class="entry-title entry-title-large limit-line-2">
                                  <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                              </h3>

                              <div class="entry-content limit-line-4">
                                  <?php the_excerpt(); ?>
                              </div>

                              <div class="entry-meta-wrapper">

                                  <?php
                                  if ($enable_cat_highlight_date_meta) {
                                      reelcraft_posted_on($select_cat_highlight_date_format, $select_cat_highlight_date_meta_title, $select_cat_highlight_date);
                                  }
                                  ?>

                                  <?php
                                  if ($enable_cat_highlight_author_meta) {
                                      reelcraft_posted_by($select_cat_highlight_author_meta, $cat_highlight_author_meta_title);
                                  }
                                  ?>

                              </div>
                              
                              <a href="<?php the_permalink(); ?>" class="wpi-button wpi-button-primary main-banner-btn with-icon">
                                <span>
                                  Watch Now
                                  
                                  <?php reelcraft_the_theme_svg('play'); ?>
                                </span>
                              </a>
                            </div>
                          </div>

                        </article>
                      </div>
                    <?php
                    endwhile;
                  wp_reset_postdata();
                endif; ?>
            </div>

            <div class="swiper-pagination"></div>
      </divd>
    </div>
  </div>
</section>
