<?php 
$enable_featured_category = reelcraft_get_option('enable_featured_category');
$featured_category_title = reelcraft_get_option('featured_category_title');
?>
<?php if ($enable_featured_category ) { ?>
<section class="wpi-section wpi-categories-section">
    <div class="wrapper wrapper-gutter-medium">
        <?php if ($featured_category_title): ?>
            <header class="theme-section-header">
                <h2 class="theme-header-title">
                    <?php echo esc_html($featured_category_title); ?>
                </h2>
            </header>
        <?php endif; ?>
        <div class="wpi-section-content categories-section-content">
            <?php for ($i=1; $i <= 4 ; $i++) { 
            $featured_category = reelcraft_get_option('featured_category_'.$i);
            if (!empty($featured_category)) {
            $cat_info = get_category($featured_category);
            $term_link = get_category_link($cat_info);
            $post_count = $cat_info->count;
            $term_name = $cat_info->name;
            $thumbnail_id = get_term_meta($cat_info->term_id, 'thumbnail_id', true);
            ?>
            <div class="wpi-category-panel">
                <div class="entry-category-image">
                    <a class="post-thumbnail" href="<?php echo esc_url($term_link); ?>" aria-hidden="true" tabindex="-1">
                        <?php
                        echo wp_get_attachment_image($thumbnail_id, 'medium_large');
                        ?>
                    </a>
                </div>
                <div class="entry-category-details category-details-vertical">
                  <div>
                    <h2 class="entry-title entry-title-medium">
                        <a href="<?php echo esc_url($term_link); ?>" rel="bookmark"><?php echo esc_html($term_name); ?></a>
                    </h2>
  
                    <span class="entry-category-count"><?php echo absint($post_count); echo __(' Articles','reelcraft');?> </span>
                  </div>
                </div>
            </div>
            <?php } ?>
            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>