<?php
$enable_featured_block = reelcraft_get_option('enable_featured_block');
$theme_featured_block_text = reelcraft_get_option('theme_featured_block_text');
$featured_block_post_video_on = reelcraft_get_option('featured_block_post_video_on');
$featured_block_category = reelcraft_get_option('featured_block_category');
$enable_featured_block_category_meta = reelcraft_get_option('enable_featured_block_category_meta');
$select_featured_block_category_color = reelcraft_get_option('select_featured_block_category_color');
$select_featured_block_number_of_category = reelcraft_get_option('select_featured_block_number_of_category');
$featured_block_category_label = reelcraft_get_option('featured_block_category_label');

$enable_featured_block_author_meta = reelcraft_get_option('enable_featured_block_author_meta');
$select_featured_block_author_meta = reelcraft_get_option('select_featured_block_author_meta');
$featured_block_author_meta_title = reelcraft_get_option('featured_block_author_meta_title');

$enable_featured_block_date_meta = reelcraft_get_option('enable_featured_block_date_meta');
$select_featured_block_date = reelcraft_get_option('select_featured_block_date');
$select_featured_block_date_meta_title = reelcraft_get_option('select_featured_block_date_meta_title');
$select_featured_block_date_format = reelcraft_get_option('select_featured_block_date_format');
$theme_featured_block_button_text = reelcraft_get_option('theme_featured_block_button_text');
$theme_featured_block_button_url = reelcraft_get_option('theme_featured_block_button_url');

$post_args = array(
  'post_type' => 'post',
  'posts_per_page' => 8,
  'post_status' => 'publish',
  'orderby' => 'date',
  'order' => 'DESC',
);
if (!empty($featured_block_category)) :
    $post_args['tax_query'][] = array(
        'taxonomy' => 'category',
        'field' => 'term_id',
        'terms' => absint($featured_block_category),
    );
endif;

$featured_block_posts = new WP_Query($post_args);
$archive_image_class = 'entry-image-medium image-has-radius';
$archive_image_size = '';
?>

<?php if ($enable_featured_block) { ?>
  <section class="wpi-section theme-featured-block">
    <div class="wrapper wrapper-gutter-medium">
      <div class="row-group">
        <div class="column column-lg-12">
          <?php if ($theme_featured_block_text) { ?>
              <header class="theme-section-header">
                <h2 class="theme-header-title"><?php echo esc_html($theme_featured_block_text); ?></h2>
              </header>
          <?php } ?>


          <div class="theme-section-body">
            <div class="row-group">
              <?php 
              if($featured_block_posts->have_posts()) :
                while ($featured_block_posts->have_posts()) : $featured_block_posts->the_post();
                $post_index = $featured_block_posts->current_post; ?>
                <div class="column column-lg-3 column-md-6">
                    <article id="featured-block-<?php the_ID(); ?>" <?php post_class('wpi-post'); ?>>

                      <?php if ($featured_block_post_video_on) { ?>
                          <div class="content-has-video">
                            <?php 
                            $content = get_the_content();
                                if (has_block('core/video', $content)) {
                                    reelcraft_instance_of_block('core/video', $content);
                                } elseif (has_block('core/embed', $content)) {
                                    reelcraft_instance_of_block('core/embed', $content);
                                }
                                  reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                            ?>
                          </div>
                      <?php } else {
                          reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                      } ?>

      
                      <div class="entry-details">
                        <?php
                          if ($enable_featured_block_category_meta) {
                              reelcraft_post_category($select_featured_block_category_color, $featured_block_category_label, $select_featured_block_number_of_category);
                          }
                        ?>

                        <h2 class="entry-title entry-title-small limit-line-3">
                          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h2>
      
                        <div class="entry-meta-wrapper">
      
                            <?php
                            if ($enable_featured_block_date_meta) {
                                reelcraft_posted_on($select_featured_block_date_format, $select_featured_block_date_meta_title, $select_featured_block_date);
                            }
                            ?>
      
                            <?php
                            if ($enable_featured_block_date_meta && $enable_featured_block_author_meta) { ?>
                                <div class="entry-meta-separator"></div>
                            <?php } ?>
      
                            <?php
                            if ($enable_featured_block_author_meta) {
                                reelcraft_posted_by($select_featured_block_author_meta, $featured_block_author_meta_title);
                            }
                            ?>
      
                        </div>
                        
                      </div>
                    </article>
              </div>
              <?php endwhile; ?>
              <?php wp_reset_postdata(); // Reset post data ?>
                <?php endif; ?>
            </div>
            <?php if ($theme_featured_block_button_text) { ?>
              <a class="view-more" href="<?php echo esc_html($theme_featured_block_button_url); ?>"> <?php echo esc_html($theme_featured_block_button_text); ?></a>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php } ?>