<?php
$enable_dual_cat_section = reelcraft_get_option('enable_dual_cat_section');
$dual_category_post_title_1 = reelcraft_get_option('dual_category_post_title_1');
$dual_category_post_category = reelcraft_get_option('dual_category_post_category');
$dual_category_post_video_on = reelcraft_get_option('dual_category_post_video_on');

$enable_dual_cat_author_meta = reelcraft_get_option('enable_dual_cat_author_meta');
$select_dual_cat_author_meta = reelcraft_get_option('select_dual_cat_author_meta');
$dual_cat_author_meta_title = reelcraft_get_option('dual_cat_author_meta_title');

$enable_dual_cat_date_meta = reelcraft_get_option('enable_dual_cat_date_meta');
$select_dual_cat_date = reelcraft_get_option('select_dual_cat_date');
$select_dual_cat_date_meta_title = reelcraft_get_option('select_dual_cat_date_meta_title');
$select_dual_cat_date_format = reelcraft_get_option('select_dual_cat_date_format');

$enable_dual_cat_category_meta = reelcraft_get_option('enable_dual_cat_category_meta');
$dual_cat_category_label = reelcraft_get_option('dual_cat_category_label');
$select_dual_cat_category_color = reelcraft_get_option('select_dual_cat_category_color');
$select_dual_cat_number_of_category = reelcraft_get_option('select_dual_cat_number_of_category');
if (empty($enable_dual_cat_section)) {
    return;
}
$archive_image_class = 'entry-image-big image-has-radius';
$archive_image_size = '';
?>
<section class="wpi-section theme-dual-showcase">
  <div class="wrapper wrapper-gutter-medium">
    <div class="row-group">
      <div class="column column-lg-12">
        <?php if ($dual_category_post_title_1) { ?>
          <header class="theme-section-header">
            <h2 class="theme-header-title"><?php echo esc_html($dual_category_post_title_1); ?></h2>
          </header>
        <?php } ?>
        <div class="dual-showcase-content">
          <div class="theme-article-carousel swiper">
            <div class="swiper-wrapper">
              <?php
              $dual_category_args_1 = array(
                  'post_type' => 'post',
                  'posts_per_page' => 10,
                  'post_status' => 'publish',
                  'no_found_rows' => 1,
                  'ignore_sticky_posts' => 1,
              );
              // Check for category.
              if (!empty($dual_category_post_category)) :
                  $dual_category_args_1['tax_query'] = array(
                      array(
                          'taxonomy' => 'category',
                          'field' => 'term_id',
                          'terms' => $dual_category_post_category,
                      ),
                  );
              endif;
              $dual_category_post_1 = new WP_Query($dual_category_args_1);
              if ($dual_category_post_1->have_posts()) :
                while ($dual_category_post_1->have_posts()) :
                    $dual_category_post_1->the_post(); ?>
                    <div class="swiper-slide">
                      <article id="dual-category-block-<?php the_ID(); ?>" class="wpi-post">

                          <?php if ($dual_category_post_video_on) { ?>
                              <div class="content-has-video">
                                <?php 
                                $content = get_the_content();
                                    if (has_block('core/video', $content)) {
                                        reelcraft_instance_of_block('core/video', $content);
                                    } elseif (has_block('core/embed', $content)) {
                                        reelcraft_instance_of_block('core/embed', $content);
                                    }
                                      reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                                ?>
                              </div>
                          <?php } else {
                              reelcraft_post_thumbnail($archive_image_class, $archive_image_size);
                          } ?>
  
                        <div class="entry-details">
                            <?php
                            if ($enable_dual_cat_category_meta) {
                                reelcraft_post_category($select_dual_cat_category_color, $dual_cat_category_label, $select_dual_cat_number_of_category);
                            }
                            ?>
                            <h3 class="entry-title entry-title-xsmall">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            <div class="entry-meta-wrapper">
  
                                <?php
                                if ($enable_dual_cat_date_meta) {
                                    reelcraft_posted_on($select_dual_cat_date_format, $select_dual_cat_date_meta_title, $select_dual_cat_date);
                                }
                                ?>
  
                                <?php
                                if ($enable_dual_cat_author_meta) {
                                    reelcraft_posted_by($select_dual_cat_author_meta, $dual_cat_author_meta_title);
                                }
                                ?>
  
                            </div>
                        </div>
                      </article>
                    </div>
                  <?php
                  endwhile;
                wp_reset_postdata();
              endif; ?>
            </div>

            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
        </div>
      </div>
  </div>
</section>