<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Reelcraft
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-default'); ?>>
  <?php reelcraft_post_thumbnail(); ?>

  <div class="entry-details">
    <header class="entry-header">
      <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
  
      <?php if ( 'post' === get_post_type() ) : ?>
      <div class="entry-meta-wrapper">
        <?php
        reelcraft_posted_on();
        reelcraft_posted_by();
        ?>
      </div><!-- .entry-meta -->
      <?php endif; ?>
    </header><!-- .entry-header -->

    <div class="entry-summary limit-line-4">
      <?php the_excerpt(); ?>
    </div><!-- .entry-summary -->
  
    <footer class="entry-footer">
      <?php reelcraft_entry_footer(); ?>
    </footer><!-- .entry-footer -->
  </div>

</article><!-- #post-<?php the_ID(); ?> -->
