<?php
/**
 * Reelcraft Admin Class.
 *
 * @package Reelcraft
 * @since   1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Reelcraft_Admin')) :
    /**
     * Reelcraft_Admin Class.
     */
    class Reelcraft_Admin
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
            add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        }

        /**
         * Localize array for import button AJAX request.
         */
        public function enqueue_scripts()
        {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            wp_enqueue_style('reelcraft-admin-style', get_template_directory_uri() . '/inc/admin/dashboard/css/admin' . $suffix . '.css', array(), REELCRAFT_VERSION);
            wp_style_add_data('reelcraft-admin-style', 'rtl', 'replace');

            wp_enqueue_script('reelcraft-plugin-install-helper', get_template_directory_uri() . '/inc/admin/dashboard/js/admin.js', array('jquery'), REELCRAFT_VERSION, true);
            $welcome_data = array(
                'uri' => esc_url(admin_url('/themes.php?page=reelcraft&tab=starter-templates')),
                'btn_text' => esc_html__('Processing...', 'reelcraft'),
                'nonce' => wp_create_nonce('reelcraft_demo_import_nonce'),
                'admin_url' => esc_url(admin_url()),
                'ajaxurl' => admin_url('admin-ajax.php'), // Include this line for using admin-ajax.php
            );
            wp_localize_script('reelcraft-plugin-install-helper', 'reelcraftRedirectDemoPage', $welcome_data);
        }
    }
endif;
return new Reelcraft_Admin();
