<?php
/**
 * All settings related to popular block post.
 *
 * @package Reelcraft
 */

 $wp_customize->add_section(
	'theme_latest_post',
	array(
		'title' => esc_html__( 'Latest Post Section', 'reelcraft' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

 $wp_customize->add_setting(
  'reelcraft_options[enable_theme_latest_post]',
  array(
      'default'           => $reelcraft_default['enable_theme_latest_post'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_theme_latest_post]',
  array(
      'label'       => esc_html__( 'Enable Latest Post', 'reelcraft' ),
      'section'     => 'theme_latest_post',
      'type'        => 'checkbox',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[theme_latest_post_title]',
  array(
      'default' => $reelcraft_default['theme_latest_post_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_latest_post_title]',
  array(
      'label' => __('Section Text', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'reelcraft_options[theme_latest_post_category]',
    array(
        'default'           => $reelcraft_default['theme_latest_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Reelcraft_Dropdown_Taxonomies_Control(
        $wp_customize,
        'reelcraft_options[theme_latest_post_category]',
        array(
            'label'           => __( 'Choose Category', 'reelcraft' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'reelcraft' ),
            'section'         => 'theme_latest_post',
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[theme_latest_post_video_on]',
    array(
        'default'           => $reelcraft_default['theme_latest_post_video_on'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[theme_latest_post_video_on]',
    array(
        'label'       => esc_html__( 'Enable Video On Image Hover', 'reelcraft' ),
        'section'     => 'theme_latest_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
  'reelcraft_options[enable_theme_latest_post_category_meta]',
  array(
      'default' => $reelcraft_default['enable_theme_latest_post_category_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_theme_latest_post_category_meta]',
  array(
      'label' => esc_html__('Enable Category Meta', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'checkbox',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[theme_latest_post_category_label]',
  array(
      'default' => $reelcraft_default['theme_latest_post_category_label'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_latest_post_category_label]',
  array(
      'label' => __('Category Label', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_category_color]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_category_color'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_category_color]',
  array(
      'label' => esc_html__('Select Category Color', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'select',
      'choices' => reelcraft_category_color(),
  )
);

$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_number_of_category]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_number_of_category'],
      'sanitize_callback' => 'absint',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_number_of_category]',
  array(
      'label' => __('Number of Category', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'number',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[enable_theme_latest_post_author_meta]',
  array(
      'default' => $reelcraft_default['enable_theme_latest_post_author_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_theme_latest_post_author_meta]',
  array(
      'label' => esc_html__('Display Author Meta', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'checkbox',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_author_meta]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_author_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_author_meta]',
  array(
      'label' => esc_html__('Select Author Meta', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'select',
      'choices' => reelcraft_author_meta(),
  )
);
$wp_customize->add_setting(
  'reelcraft_options[theme_latest_post_author_meta_title]',
  array(
      'default' => $reelcraft_default['theme_latest_post_author_meta_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_latest_post_author_meta_title]',
  array(
      'label' => __('Author Meta Text', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[enable_theme_latest_post_date_meta]',
  array(
      'default' => $reelcraft_default['enable_theme_latest_post_date_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_theme_latest_post_date_meta]',
  array(
      'label' => esc_html__('Display Published Date', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'checkbox',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_date]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_date'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_date]',
  array(
      'label' => esc_html__('Select Single Date Meta', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'select',
      'choices' => reelcraft_date_meta(),
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_date_meta_title]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_date_meta_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_date_meta_title]',
  array(
      'label' => __('Date Text', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_theme_latest_post_date_format]',
  array(
      'default' => $reelcraft_default['select_theme_latest_post_date_format'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_theme_latest_post_date_format]',
  array(
      'label' => esc_html__('Select Date Format', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'select',
      'choices' => reelcraft_get_date_formats(),
  )
);


$wp_customize->add_setting(
  'reelcraft_options[theme_latest_post_button_text]',
  array(
      'default' => $reelcraft_default['theme_latest_post_button_text'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_latest_post_button_text]',
  array(
      'label' => __('Button Text', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[theme_latest_post_button_url]',
  array(
      'default' => $reelcraft_default['theme_latest_post_button_url'],
      'sanitize_callback' => 'esc_url_raw',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_latest_post_button_url]',
  array(
      'label' => __('Button URL', 'reelcraft'),
      'section' => 'theme_latest_post',
      'type' => 'text',
  )
);

