<?php
/**
 * All settings related to popular block post.
 *
 * @package Reelcraft
 */

 $wp_customize->add_section(
	'featured_block',
	array(
		'title' => esc_html__( 'Featured Block Section', 'reelcraft' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

 $wp_customize->add_setting(
  'reelcraft_options[enable_featured_block]',
  array(
      'default'           => $reelcraft_default['enable_featured_block'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_featured_block]',
  array(
      'label'       => esc_html__( 'Enable Featured Block', 'reelcraft' ),
      'section'     => 'featured_block',
      'type'        => 'checkbox',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[theme_featured_block_text]',
  array(
      'default' => $reelcraft_default['theme_featured_block_text'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_featured_block_text]',
  array(
      'label' => __('Section Title', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'reelcraft_options[featured_block_category]',
    array(
        'default'           => $reelcraft_default['featured_block_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Reelcraft_Dropdown_Taxonomies_Control(
        $wp_customize,
        'reelcraft_options[featured_block_category]',
        array(
            'label'           => __( 'Choose Category', 'reelcraft' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'reelcraft' ),
            'section'         => 'featured_block',
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[featured_block_post_video_on]',
    array(
        'default'           => $reelcraft_default['featured_block_post_video_on'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[featured_block_post_video_on]',
    array(
        'label'       => esc_html__( 'Enable Video On Image Hover', 'reelcraft' ),
        'section'     => 'featured_block',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
  'reelcraft_options[enable_featured_block_category_meta]',
  array(
      'default' => $reelcraft_default['enable_featured_block_category_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_featured_block_category_meta]',
  array(
      'label' => esc_html__('Enable Category Meta', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'checkbox',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[featured_block_category_label]',
  array(
      'default' => $reelcraft_default['featured_block_category_label'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[featured_block_category_label]',
  array(
      'label' => __('Category Label', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_category_color]',
  array(
      'default' => $reelcraft_default['select_featured_block_category_color'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_category_color]',
  array(
      'label' => esc_html__('Select Category Color', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'select',
      'choices' => reelcraft_category_color(),
  )
);

$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_number_of_category]',
  array(
      'default' => $reelcraft_default['select_featured_block_number_of_category'],
      'sanitize_callback' => 'absint',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_number_of_category]',
  array(
      'label' => __('Number of Category', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'number',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[enable_featured_block_author_meta]',
  array(
      'default' => $reelcraft_default['enable_featured_block_author_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_featured_block_author_meta]',
  array(
      'label' => esc_html__('Display Author Meta', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'checkbox',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_author_meta]',
  array(
      'default' => $reelcraft_default['select_featured_block_author_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_author_meta]',
  array(
      'label' => esc_html__('Select Author Meta', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'select',
      'choices' => reelcraft_author_meta(),
  )
);
$wp_customize->add_setting(
  'reelcraft_options[featured_block_author_meta_title]',
  array(
      'default' => $reelcraft_default['featured_block_author_meta_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[featured_block_author_meta_title]',
  array(
      'label' => __('Author Meta Text', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[enable_featured_block_date_meta]',
  array(
      'default' => $reelcraft_default['enable_featured_block_date_meta'],
      'sanitize_callback' => 'reelcraft_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'reelcraft_options[enable_featured_block_date_meta]',
  array(
      'label' => esc_html__('Display Published Date', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'checkbox',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_date]',
  array(
      'default' => $reelcraft_default['select_featured_block_date'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_date]',
  array(
      'label' => esc_html__('Select Single Date Meta', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'select',
      'choices' => reelcraft_date_meta(),
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_date_meta_title]',
  array(
      'default' => $reelcraft_default['select_featured_block_date_meta_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_date_meta_title]',
  array(
      'label' => __('Date Text', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);
$wp_customize->add_setting(
  'reelcraft_options[select_featured_block_date_format]',
  array(
      'default' => $reelcraft_default['select_featured_block_date_format'],
      'sanitize_callback' => 'reelcraft_sanitize_select',
  )
);
$wp_customize->add_control(
  'reelcraft_options[select_featured_block_date_format]',
  array(
      'label' => esc_html__('Select Date Format', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'select',
      'choices' => reelcraft_get_date_formats(),
  )
);



$wp_customize->add_setting(
  'reelcraft_options[theme_featured_block_button_text]',
  array(
      'default' => $reelcraft_default['theme_featured_block_button_text'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_featured_block_button_text]',
  array(
      'label' => __('Section Button Text', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
  'reelcraft_options[theme_featured_block_button_url]',
  array(
      'default' => $reelcraft_default['theme_featured_block_button_url'],
      'sanitize_callback' => 'esc_url_raw',
  )
);
$wp_customize->add_control(
  'reelcraft_options[theme_featured_block_button_url]',
  array(
      'label' => __('Section Button URL', 'reelcraft'),
      'section' => 'featured_block',
      'type' => 'text',
  )
);

