<?php
$wp_customize->add_section(
    'pagination_options',
    array(
        'title' => esc_html__( 'Pagination Options', 'reelcraft' ),
        'panel' => 'archive_options_panel',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[select_pagination_style]',
    array(
        'default'           => $reelcraft_default['select_pagination_style'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_pagination_style]',
    array(
        'label'         => esc_html__( 'Select Pagination Style', 'reelcraft' ),
        'section'     => 'pagination_options',
        'type'        => 'select',
        'choices'       => reelcraft_pagination_style_choice(),

    )
);


$wp_customize->add_section(
    'excerpt_options',
    array(
        'title' => esc_html__( 'Excerpt Options', 'reelcraft' ),
        'panel' => 'archive_options_panel',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[number_of_word_in_excerpt]',
    array(
        'default'           => $reelcraft_default['number_of_word_in_excerpt'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[number_of_word_in_excerpt]',
    array(
        'label'         => esc_html__( 'Number Of Excerpt Word', 'reelcraft' ),
        'section'     => 'excerpt_options',
        'type'        => 'number',

    )
);


$wp_customize->add_setting(
    'excerpt_posts_title_limit',
    array(
        'default'           => $reelcraft_default['excerpt_posts_title_limit'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'excerpt_posts_title_limit',
    array(
        'label'    => __( 'Excerpt Line Limit', 'reelcraft' ),
        'section'  => 'excerpt_options',
        'type'     => 'select',
        'choices'  => reelcraft_line_limit_choices(),
    )
);

$wp_customize->add_setting(
    'reelcraft_options[archive_excerpt_button_text]',
    array(
        'default'           => $reelcraft_default['archive_excerpt_button_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[archive_excerpt_button_text]',
    array(
        'label'    => __( 'Excerpt Button Text', 'reelcraft' ),
        'section'  => 'excerpt_options',
        'type'     => 'text',
    )
);