<?php
/**
 * All settings related to archive.
 *
 * @package Reelcraft
 */
$wp_customize->add_section(
	'archive_options',
	array(
		'title' => esc_html__( 'Archive Options', 'reelcraft' ),
		'panel' => 'archive_options_panel',
	)
);

// Archive Layout.
$wp_customize->add_setting(
    'reelcraft_options[archive_layout]',
    array(
        'default'           => $reelcraft_default['archive_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'reelcraft_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Reelcraft_Custom_Radio_Image_Control(
        $wp_customize,
        'reelcraft_options[archive_layout]',
        array(
            'label'         => esc_html__( 'Archive Layout', 'reelcraft' ),
            'section'       => 'archive_options',
            'choices'       => reelcraft_get_archive_layouts(),
        )
    )
);

$wp_customize->add_setting(
    'reelcraft_section_seperator_archive_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Reelcraft_Seperator_Control(
        $wp_customize,
        'reelcraft_section_seperator_archive_1',
        array(
            'label'         => esc_html__( 'Archive Meta Options', 'reelcraft' ),
            'settings' => 'reelcraft_section_seperator_archive_1',
            'section' => 'archive_options',
        )
    )
);


$wp_customize->add_setting(
    'reelcraft_options[archive_posts_title_limit]',
    array(
        'default'           => $reelcraft_default['archive_posts_title_limit'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[archive_posts_title_limit]',
    array(
        'label'    => __( 'Title Line Limit', 'reelcraft' ),
        'section'  => 'archive_options',
        'type'     => 'select',
        'choices'  => reelcraft_line_limit_choices(),
    )
);


$wp_customize->add_setting(
    'reelcraft_options[enable_excerpt_on_archive_1]',
    array(
        'default'           => $reelcraft_default['enable_excerpt_on_archive_1'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_excerpt_on_archive_1]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'reelcraft_is_archive_excerpt_callbac_1',

    )
);



$wp_customize->add_setting(
    'reelcraft_options[enable_excerpt_on_archive_2]',
    array(
        'default'           => $reelcraft_default['enable_excerpt_on_archive_2'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_excerpt_on_archive_2]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'reelcraft_is_archive_excerpt_callbac_2',
        
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_archive_author_meta]',
    array(
        'default'           => $reelcraft_default['enable_archive_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_archive_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_author_meta]',
    array(
        'default'           => $reelcraft_default['select_author_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => reelcraft_author_meta(),
        'active_callback' => 'reelcraft_is_archive_author_meta_enabled',


    )
);

$wp_customize->add_setting(
    'reelcraft_options[archive_author_meta_title]',
    array(
        'default'           => $reelcraft_default['archive_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[archive_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'reelcraft' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                reelcraft_is_archive_author_meta_enabled( $control )
                &&
                reelcraft_archive_author_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_archive_date_meta]',
    array(
        'default'           => $reelcraft_default['enable_archive_date_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_archive_date_meta]',
    array(
        'label'       => esc_html__( 'Show Date Meta', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_archive_date]',
    array(
        'default'           => $reelcraft_default['select_archive_date'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_archive_date]',
    array(
        'label'         => esc_html__( 'Date Meta Display Options', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => reelcraft_date_meta(),
        'active_callback' => 'reelcraft_is_archive_date_meta_enabled',

    )
);

$wp_customize->add_setting(
    'reelcraft_options[archive_date_meta_title]',
    array(
        'default'           => $reelcraft_default['archive_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[archive_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'reelcraft' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                reelcraft_is_archive_date_meta_enabled( $control )
                &&
                reelcraft_archive_date_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_date_format]',
    array(
        'default'           => $reelcraft_default['select_date_format'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> reelcraft_get_date_formats(),
        'active_callback' => 'reelcraft_is_archive_date_meta_enabled',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_category_meta]',
    array(
        'default'           => $reelcraft_default['enable_category_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[number_of_category_to_display]',
    array(
        'default' => $reelcraft_default['number_of_category_to_display'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'reelcraft_options[number_of_category_to_display]',
    array(
        'label' => __('Number of Category', 'reelcraft'),
        'section' => 'archive_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[archive_category_label]',
    array(
        'default'           => $reelcraft_default['archive_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'reelcraft_options[archive_category_label]',
    array(
        'label'    => __( 'Category Title', 'reelcraft' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => 'reelcraft_is_archive_category_meta_enabled',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[select_category_color]',
    array(
        'default'           => $reelcraft_default['select_category_color'],
        'sanitize_callback' => 'reelcraft_sanitize_select',
    )
);
$wp_customize->add_control(
    'reelcraft_options[select_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> reelcraft_category_color(),
        'active_callback' => 'reelcraft_is_archive_category_meta_enabled',

    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_tag_meta]',
    array(
        'default'           => $reelcraft_default['enable_tag_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'reelcraft_options[enable_comment_meta]',
    array(
        'default'           => $reelcraft_default['enable_comment_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_comment_meta]',
    array(
        'label'       => esc_html__( 'Enable Comment Meta', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'reelcraft_options[enable_read_time_meta]',
    array(
        'default'           => $reelcraft_default['enable_read_time_meta'],
        'sanitize_callback' => 'reelcraft_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'reelcraft_options[enable_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'reelcraft' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);
