<?php
/**
 * Default customizer values.
 *
 * @package Reelcraft
 */
if (!function_exists('reelcraft_get_all_customizer_default_values')) :
    /**
     * Get default customizer values.
     *
     * @return array Default customizer values.
     * @since 1.0.0
     *
     */
    function reelcraft_get_all_customizer_default_values()
    {

        $defaults = array();

        // sidebar
        $defaults['enable_latest_post'] = true;
        $defaults['hide_title'] = false;
        $defaults['hide_tagline'] = false;

        $defaults['sidebar_layout_option'] = 'right-sidebar';
        $defaults['single_sidebar_layout_option'] = 'right-sidebar';
        $defaults['enable_sidebar_fix_archive'] = true;
        $defaults['enable_sidebar_fix_single'] = true;

        // preloader
        $defaults['select_header_layout_style'] = 'header_style_4';
        $defaults['enable_preloader_options'] = false;
        $defaults['reelcraft_preloader_style'] = 'style-8';

        // breadrumbs
        $defaults['enable_breadcrumb'] = true;

        $defaults['enable_social_mobile_menu'] = true;
        $defaults['select_mobile_social_menu_style'] = 'has-brand-background ';
        $defaults['enable_mobile_social_nav_border_radius'] = true;
        $defaults['enable_copyright_in_menu'] = true;

        //streaming
        $defaults['enable_streaming_button'] = true;
        $defaults['streaming_button_text'] = esc_html__('Stream On Demand', 'reelcraft');
        $defaults['streaming_button_url'] = '';

        // main banner 
        $defaults['enable_main_banner_section'] = true;
        $defaults['banner_slider_post_category'] = '';
        $defaults['banner_lists_post_category'] = '';
        $defaults['banner_featured_player_category'] = '';
        $defaults['enable_main_banner_author_meta'] = false;
        $defaults['select_main_banner_author_meta'] = 'with_avatar_image';
        $defaults['select_main_banner_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['main_banner_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_main_banner_date_meta'] = true;
        $defaults['select_main_banner_date'] = 'with_icon';
        $defaults['select_main_banner_date_format'] = 'classic';
        $defaults['enable_main_banner_category_meta'] = true;
        $defaults['main_banner_category_label'] = '';
        $defaults['select_main_banner_category_color'] = 'has-text-color';
        $defaults['select_main_banner_number_of_category'] = 1;

        // article list
        $defaults['enable_article_list_section'] = true;
        $defaults['select_article_list_title'] = esc_html__('Featued - 1', 'reelcraft');
        $defaults['article_list_post_video_on'] = false;
        $defaults['enable_article_list_section'] = true;
        $defaults['enable_article_list_author_meta'] = true;
        $defaults['select_article_list_author_meta'] = 'with_avatar_image';
        $defaults['select_article_list_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['article_list_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_article_list_date_meta'] = true;
        $defaults['select_article_list_date'] = 'with_icon';
        $defaults['select_article_list_date_format'] = 'classic';
        $defaults['enable_article_list_category_meta'] = true;
        $defaults['article_list_category_label'] = '';
        $defaults['select_article_list_category_color'] = 'has-text-color';
        $defaults['select_article_list_number_of_category'] = 1;


        // Dual Category 
        $defaults['enable_dual_cat_section'] = true;
        $defaults['dual_category_post_title_1'] = esc_html__('Featued Posts', 'reelcraft');
        $defaults['dual_category_post_category'] = '';
        $defaults['dual_category_post_video_on'] = true;
        $defaults['enable_dual_cat_author_meta'] = false;
        $defaults['select_dual_cat_author_meta'] = 'with_avatar_image';
        $defaults['select_dual_cat_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['dual_cat_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_dual_cat_date_meta'] = true;
        $defaults['select_dual_cat_date'] = 'with_icon';
        $defaults['select_dual_cat_date_format'] = 'classic';
        $defaults['enable_dual_cat_category_meta'] = true;
        $defaults['dual_cat_category_label'] = '';
        $defaults['select_dual_cat_category_color'] = 'has-text-color';
        $defaults['select_dual_cat_number_of_category'] = 1;


        // Single Category Highlight 
        $defaults['enable_cat_highlight_section'] = true;
        $defaults['cat_highlight_post_title'] = esc_html__('Exclusive', 'reelcraft');
        $defaults['cat_highlight_post_category'] = '';
        $defaults['enable_cat_highlight_author_meta'] = false;
        $defaults['select_cat_highlight_author_meta'] = 'with_avatar_image';
        $defaults['select_cat_highlight_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['cat_highlight_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_cat_highlight_date_meta'] = true;
        $defaults['select_cat_highlight_date'] = 'with_icon';
        $defaults['select_cat_highlight_date_format'] = 'classic';
        $defaults['enable_cat_highlight_category_meta'] = true;
        $defaults['cat_highlight_category_label'] = '';
        $defaults['select_cat_highlight_category_color'] = 'has-text-color';
        $defaults['select_cat_highlight_number_of_category'] = 1;

        // Spotlight 
        $defaults['enable_spotlight_section'] = true;
        $defaults['spotlight_post_title_1'] = esc_html__('Featued - 1', 'reelcraft');
        $defaults['spotlight_post_category_1'] = '';
        $defaults['spotlight_post_video_on'] = false;
        $defaults['enable_spotlight_author_meta'] = false;
        $defaults['select_spotlight_author_meta'] = 'with_avatar_image';
        $defaults['select_spotlight_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['spotlight_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_spotlight_date_meta'] = true;
        $defaults['select_spotlight_date'] = 'with_icon';
        $defaults['select_spotlight_date_format'] = 'classic';
        $defaults['enable_spotlight_category_meta'] = true;
        $defaults['spotlight_category_label'] = '';
        $defaults['select_spotlight_category_color'] = 'has-text-color';
        $defaults['select_spotlight_number_of_category'] = 1;

        // excerpt
        $defaults['number_of_word_in_excerpt'] = '20';
        $defaults['excerpt_posts_title_limit'] = '';
        $defaults['archive_excerpt_button_text'] = esc_html__('Learn More', 'reelcraft');

        // archive options
        $defaults['archive_layout'] = 'archive_style_1';
        $defaults['archive_posts_title_limit'] = '';
        $defaults['enable_excerpt_on_archive_1'] = true;
        $defaults['enable_excerpt_on_archive_2'] = true;
        $defaults['select_author_meta'] = 'with_label';
        $defaults['archive_author_meta_title'] = esc_html__('by', 'reelcraft');
        $defaults['enable_archive_author_meta'] = true;
        $defaults['enable_archive_date_meta'] = true;
        $defaults['archive_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['select_date_format'] = 'classic';
        $defaults['select_archive_date'] = 'with_label';


        $defaults['enable_category_meta'] = true;
        $defaults['archive_category_label'] = '';
        $defaults['select_category_style'] = 'archive_cat_style_2';
        $defaults['number_of_category_to_display'] = '1';
        $defaults['select_category_color'] = 'none';
        $defaults['enable_tag_meta'] = false;
        $defaults['enable_comment_meta'] = true;
        $defaults['enable_read_time_meta'] = true;
        $defaults['select_read_time_style'] = 'archive_read_time_style_1';
        $defaults['enable_excerpt'] = true;

        $defaults['select_pagination_style'] = 'pagination_default';


        // single options
        $defaults['enable_single_author_meta'] = true;
        $defaults['single_author_meta_title'] = esc_html__('by', 'reelcraft');
        $defaults['select_single_author_meta'] = 'with_label';
        $defaults['enable_single_date_meta'] = true;
        $defaults['select_single_date'] = 'with_label';
        $defaults['single_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['select_single_date_format'] = 'classic';
        $defaults['enable_single_category_meta'] = true;
        $defaults['single_category_label'] = '';
        $defaults['select_single_category_color'] = 'has-text-color';
        $defaults['enable_single_tag_meta'] = true;
        $defaults['enable_single_read_time_meta'] = true;


        $defaults['show_author_info'] = true;
        $defaults['show_sticky_article_navigation'] = true;

        // single related post
        $defaults['show_related_posts'] = true;
        $defaults['related_posts_text'] = __('You May Also Like', 'reelcraft');
        $defaults['no_of_related_posts'] = 3;
        $defaults['related_posts_orderby'] = 'date';
        $defaults['related_posts_order'] = 'desc';
        $defaults['author_posts_orderby'] = 'date';
        $defaults['enable_related_posts_author_meta'] = true;
        $defaults['select_related_posts_author_meta'] = 'with_icon';
        $defaults['single_related_post_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['related_posts_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_related_posts_date_meta'] = true;
        $defaults['select_related_posts_date'] = 'with_icon';
        $defaults['select_related_posts_date_format'] = 'classic';
        $defaults['enable_related_posts_category_meta'] = true;
        $defaults['related_posts_category_label'] = '';
        $defaults['select_related_posts_category_color'] = 'none';
        $defaults['select_related_posts_number_of_category'] = 1;

        // single author post
        $defaults['author_posts_order'] = 'desc';
        $defaults['show_author_posts'] = true;
        $defaults['author_posts_text'] = __('More From Author', 'reelcraft');
        $defaults['no_of_author_posts'] = 3;

        $defaults['enable_author_posts_author_meta'] = true;
        $defaults['select_author_posts_author_meta'] = 'with_icon';
        $defaults['single_author_post_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['author_posts_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_author_posts_date_meta'] = true;
        $defaults['select_author_posts_date'] = 'with_icon';
        $defaults['select_author_posts_date_format'] = 'classic';
        $defaults['enable_author_posts_category_meta'] = true;
        $defaults['author_posts_category_label'] = '';
        $defaults['select_author_posts_category_color'] = 'none';
        $defaults['select_author_posts_number_of_category'] = 1;

        // featured block post
        $defaults['enable_theme_latest_post'] = true;
        $defaults['theme_latest_post_video_on'] = false;
        $defaults['theme_latest_post_category'] = '';
        $defaults['enable_theme_latest_post_category_meta'] = true;
        $defaults['enable_theme_latest_post_author_meta'] = false;
        $defaults['select_theme_latest_post_author_meta'] = 'with_avatar_image';
        $defaults['theme_latest_post_title'] = esc_html__('Latest Post', 'reelcraft');
        $defaults['select_theme_latest_post_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['theme_latest_post_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_theme_latest_post_date_meta'] = true;
        $defaults['select_theme_latest_post_date'] = 'with_icon';
        $defaults['select_theme_latest_post_date_format'] = 'classic';
        $defaults['theme_latest_post_category_label'] = '';
        $defaults['select_theme_latest_post_category_color'] = 'has-text-color';
        $defaults['select_theme_latest_post_number_of_category'] = 1;
        $defaults['theme_latest_post_button_text'] = esc_html__('View more', 'reelcraft');
        $defaults['theme_latest_post_button_url'] = '';

        // featured block post
        $defaults['enable_featured_block'] = true;
        $defaults['theme_featured_block_text'] = esc_html__('Featured Now', 'reelcraft');
        $defaults['featured_block_category'] = '';
        $defaults['featured_block_post_video_on'] = false;
        $defaults['enable_featured_block_category_meta'] = true;
        $defaults['enable_featured_block_author_meta'] = false;
        $defaults['select_featured_block_author_meta'] = 'with_avatar_image';
        $defaults['select_featured_block_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['featured_block_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_featured_block_date_meta'] = true;
        $defaults['select_featured_block_date'] = 'with_icon';
        $defaults['select_featured_block_date_format'] = 'classic';
        $defaults['featured_block_category_label'] = '';
        $defaults['select_featured_block_category_color'] = 'has-text-color';
        $defaults['select_featured_block_number_of_category'] = 1;
        $defaults['theme_featured_block_button_text'] = esc_html__('View more', 'reelcraft');
        $defaults['theme_featured_block_button_url'] = '';

        // footer recommended section
        $defaults['enable_recommended_post'] = false;
        $defaults['recommended_post_layout'] = 'wpi-post-recommendation-1';
        $defaults['recommended_post_title'] = esc_html__('Just For You', 'reelcraft');
        $defaults['recommended_post_category'] = '';
        
        $defaults['enable_recommended_post_author_meta'] = false;
        $defaults['select_recommended_post_author_meta'] = 'with_avatar_image';
        $defaults['select_recommended_post_date_meta_title'] = esc_html__('Posted on', 'reelcraft');
        $defaults['recommended_post_author_meta_title'] = esc_html__('Posted by', 'reelcraft');
        $defaults['enable_recommended_post_date_meta'] = true;
        $defaults['select_recommended_post_date'] = 'with_icon';
        $defaults['select_recommended_post_date_format'] = 'classic';
        $defaults['enable_recommended_post_category_meta'] = true;
        $defaults['recommended_post_category_label'] = '';
        $defaults['select_recommended_post_category_color'] = 'has-text-color';
        $defaults['select_recommended_post_number_of_category'] = 1;

        //featured category section
        $defaults['enable_featured_category'] = false;
        $defaults['featured_category_title'] = esc_html__('Categories', 'reelcraft');
        // footer widget section
        $defaults['enable_footer_widget'] = true;
        $defaults['footer_column_layout'] = 'footer_layout_2';

        // footer section
        $defaults['copyright_text'] = esc_html__('&copy; All rights reserved. Proudly powered by WordPress.', 'reelcraft');
        $defaults['copyright_date_format'] = 'Y';
        $defaults['enable_footer_nav'] = false;
        $defaults['enable_footer_social_nav'] = true;
        $defaults['enable_footer_social_nav_border_radius'] = false;
        $defaults['select_footer_social_menu_style'] = 'has-brand-background';
        
        $defaults['enable_footer_scroll_to_top'] = true;
        $defaults['enable_footer_progressbar'] = true;


        $defaults = apply_filters('reelcraft_default_customizer_values', $defaults);
        return $defaults;
    }
endif;