<?php
/**
 * Title: Real Estate Slider
 * Slug: real-estate-blocks/slider
 * Description: A gallery with a carousel for real estate business.
 * Categories: real-estate-blocks/general
 */ 
?>
<div class="wp-block-group">

    <h2 class="has-text-align-center">Featured Properties</h2>
    <div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
    <?php $theme_directory = get_template_directory_uri(); ?>

    <!-- Editor-specific preview block - hidden by default for frontend -->
    <div class="slider-editor-preview" style="display: none;">
            <!-- wp:image {"sizeSlug":"large","linkDestination":"none"} -->
                <figure class="wp-block-image size-large"><img src="<?php echo esc_url($theme_directory) . '/assets/images/slider1.jpg'; ?>" alt="Slider Preview" /></figure>
            <!-- /wp:image -->
    </div>



    <div class="slider-container">
        <button class="slider-prev">‹</button>
        <div class="slider-wrapper">
            <div class="slide">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/slider1.jpg'; ?>" alt="Property 1" />
            </div>
            <div class="slide">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/slider2.jpg'; ?>" alt="Property 2" />
            </div>
            <div class="slide">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/slider3.jpg'; ?>" alt="Property 3" />
            </div>
        </div>
        <button class="slider-next">›</button>
    </div>
</div>