<?php
/**
 * Title: Three Column Services
 * Slug: real-estate-blocks/services-three-column
 * Categories: real-estate-blocks/services
 */

$theme_directory = get_template_directory_uri();
?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-soft-background has-background has-base-2-background-color" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
	<!-- wp:heading {"textAlign":"center","style":{"spacing":{"marginBottom":"var:preset|spacing|50"}}} -->
	<h2 class="wp-block-heading has-text-align-center">Our Real Estate Services</h2>
	<!-- /wp:heading -->

	<!-- wp:columns {"align":"wide"} -->
	<div class="wp-block-columns alignwide">

		<!-- wp:column {"verticalAlignment":"top","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
		<div class="wp-block-column is-vertically-aligned-top">
			<!-- wp:image {"align":"center","width":"64px","height":"64px","sizeSlug":"full","linkDestination":"none"} -->
			<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-valuation.png'; ?>" alt="Property Valuation Icon" style="width:64px;height:64px"/></figure>
			<!-- /wp:image -->
			<!-- wp:heading {"textAlign":"center","level":3} -->
			<h3 class="wp-block-heading has-text-align-center">Property Valuation</h3>
			<!-- /wp:heading -->
			<!-- wp:paragraph {"align":"center"} -->
			<p class="has-text-align-center">We offer precise and detailed valuations to ensure you get the best value for your property.</p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"verticalAlignment":"top","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
		<div class="wp-block-column is-vertically-aligned-top">
			<!-- wp:image {"align":"center","width":"64px","height":"64px","sizeSlug":"full","linkDestination":"none"} -->
			<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-consulting.png'; ?>" alt="Legal Consulting Icon" style="width:64px;height:64px"/></figure>
			<!-- /wp:image -->
			<!-- wp:heading {"textAlign":"center","level":3} -->
			<h3 class="wp-block-heading has-text-align-center">Legal Consulting</h3>
			<!-- /wp:heading -->
			<!-- wp:paragraph {"align":"center"} -->
			<p class="has-text-align-center">Our team of experts provides full legal support for a safe and smooth real estate transaction.</p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"verticalAlignment":"top","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
		<div class="wp-block-column is-vertically-aligned-top">
			<!-- wp:image {"align":"center","width":"64px","height":"64px","sizeSlug":"full","linkDestination":"none"} -->
			<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-photography.png'; ?>" alt="Professional Photography Icon" style="width:64px;height:64px"/></figure>
			<!-- /wp:image -->
			<!-- wp:heading {"textAlign":"center","level":3} -->
			<h3 class="wp-block-heading has-text-align-center">Professional Photography</h3>
			<!-- /wp:heading -->
			<!-- wp:paragraph {"align":"center"} -->
			<p class="has-text-align-center">Showcase your property with high-quality photos that attract more potential buyers and speed up the sale.</p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:column -->

	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->