<?php
/**
 * RapidOne Lite Theme Customizer
 *
 * @package RapidOne Lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function rapidone_lite_customize_register( $wp_customize ) {
	
function rapidone_lite_sanitize_checkbox( $checked ) {
	// Boolean check.
	return ( ( isset( $checked ) && true == $checked ) ? true : false );
}
	$wp_customize->get_setting( 'blogname' )->rapidone_lite         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->rapidone_lite  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
	    'selector' => '.site-title a',
	    'render_callback' => 'rapidone-lite_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
	    'selector' => '.site-title p',
	    'render_callback' => 'rapidone-lite_customize_partial_blogdescription',
	) );

	$wp_customize->add_setting('rapid_headerbg-color', array(
		'default' => '#ffffff',
		'sanitize_callback'	=> 'sanitize_hex_color',
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'rapid_headerbg-color',array(
			'label' => __('Header Background color','rapidone-lite'),
			'description'	=> __('Select background color for header.','rapidone-lite'),
			'section' => 'colors',
			'settings' => 'rapid_headerbg-color'
		))
	);
		
	$wp_customize->add_setting('rapid_color_scheme', array(
		'default' => '#496068',
		'sanitize_callback'	=> 'sanitize_hex_color',
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'rapid_color_scheme',array(
			'label' => __('Color Scheme','rapidone-lite'),
			'description'	=> __('Select theme main color from here.','rapidone-lite'),
			'section' => 'colors',
			'settings' => 'rapid_color_scheme'
		))
	);
	
	$wp_customize->add_setting('rapid_color_sub_scheme', array(
		'default' => '#ff6565',
		'sanitize_callback'	=> 'sanitize_hex_color',
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'rapid_color_sub_scheme',array(
			'label' => __('Color Scheme','rapidone-lite'),
			'description'	=> __('Select theme sub color from here.','rapidone-lite'),
			'section' => 'colors',
			'settings' => 'rapid_color_sub_scheme'
		))
	);
	
	$wp_customize->add_setting('rapid_footer-color', array(
		'default' => '#151515',
		'sanitize_callback'	=> 'sanitize_hex_color',
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'rapid_footer-color',array(
			'label' => __('Footer Background color','rapidone-lite'),
			'description'	=> __('Select background color for footer.','rapidone-lite'),
			'section' => 'colors',
			'settings' => 'rapid_footer-color'
		))
	);

	/******************************************************
	**	Top Header Information
	******************************************************/
	$wp_customize->add_section('rapid_tp_head',array(
		'title' => __('Setting Up Top Header', 'rapidone-lite'),
		'priority' => null,
		'description'	=> __('Add details for top header strip.','rapidone-lite'),	
	));
	$wp_customize->add_setting('rapid_tp_add',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_add',array(
		'type'	=> 'text',
		'label'	=> __('Add office address here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_mail',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_mail',array(
		'type'	=> 'text',
		'label'	=> __('Add email address here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_phn',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_phn',array(
		'type'	=> 'text',
		'label'	=> __('Add phone number here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_fb',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_fb',array(
		'type'	=> 'text',
		'label'	=> __('Add facebook account link here here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_tw',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_tw',array(
		'type'	=> 'text',
		'label'	=> __('Add twiiter account link here here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_gp',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_gp',array(
		'type'	=> 'text',
		'label'	=> __('Add google account link here here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_in',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_in',array(
		'type'	=> 'text',
		'label'	=> __('Add linkedin account link here here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('rapid_tp_pin',array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport' => 'refresh'
	));
	
	$wp_customize->add_control('rapid_tp_pin',array(
		'type'	=> 'text',
		'label'	=> __('Add pinterest account link here here','rapidone-lite'),
		'section'	=> 'rapid_tp_head'
	));
	$wp_customize->add_setting('hide_tphead',array(
		'default' => true,
		'sanitize_callback' => 'rapidone_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));

	$wp_customize->add_control( 'hide_tphead', array(
		'settings' => 'hide_tphead',
		'section'   => 'rapid_tp_head',
		'label'     => __('Check this to hide top header.','rapidone-lite'),
		'type'      => 'checkbox'
    ));
	
	/******************************************************
	**	Theme Slider
	******************************************************/
	$wp_customize->add_section('rapid_slider',array(
		'title' => __('Setting Up Slider', 'rapidone-lite'),
		'priority' => null,
		'description'	=> __('Recommended image size (1600x720). Slider will work only when you select the static front page.','rapidone-lite'),	
	));
	$wp_customize->add_setting('rapid_slider_sbttl',array(
		'default'	=> __('','rapidone-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('rapid_slider_sbttl',array(
		'label'	=> __('Add slide sub heading text.','rapidone-lite'),
		'section'	=> 'rapid_slider',
		'setting'	=> 'rapid_slider_sbttl',
		'type'	=> 'text'
	));
	$wp_customize->add_setting('rapid-slide1',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('rapid-slide1',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for slide one:','rapidone-lite'),
		'section'	=> 'rapid_slider'
	));
	$wp_customize->add_setting('rapid-slide2',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('rapid-slide2',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for slide two:','rapidone-lite'),
		'section'	=> 'rapid_slider'
	));
	$wp_customize->add_setting('rapid-slide3',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('rapid-slide3',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for slide three:','rapidone-lite'),
		'section'	=> 'rapid_slider'
	));
	$wp_customize->add_setting('rapid_slide_more',array(
		'default'	=> __('','rapidone-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('rapid_slide_more',array(
		'label'	=> __('Add slider button text.','rapidone-lite'),
		'section'	=> 'rapid_slider',
		'setting'	=> 'rapid_slide_more',
		'type'	=> 'text'
	));
	$wp_customize->add_setting('hide_slider',array(
		'default' => true,
		'sanitize_callback' => 'rapidone_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	)); 
	$wp_customize->add_control( 'hide_slider', array(
	   'settings' => 'hide_slider',
	   'section'   => 'rapid_slider',
	   'label'     => __('Check this to hide slider.','rapidone-lite'),
	   'type'      => 'checkbox'
    ));
	
	/******************************************************
	**	Theme First Section
	******************************************************/
	$wp_customize->add_section('rapid_ser_sec',array(
		'title' => __('Setting Up Services Section', 'rapidone-lite'),
		'priority' => null,
		'description'	=> __('Select pages to display services section on homepage. This section will be displayed only when you select the static front page.','rapidone-lite'),	
	));
	$wp_customize->add_setting('service1',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('service1',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for first box','rapidone-lite'),
		'section'	=> 'rapid_ser_sec'
	));
	$wp_customize->add_setting('service2',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('service2',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for second box','rapidone-lite'),
		'section'	=> 'rapid_ser_sec'
	));
	$wp_customize->add_setting('service3',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('service3',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for third box','rapidone-lite'),
		'section'	=> 'rapid_ser_sec'
	));
	$wp_customize->add_setting('service4',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('service4',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for fourth box','rapidone-lite'),
		'section'	=> 'rapid_ser_sec'
	));
	$wp_customize->add_setting('service_more',array(
		'default'	=> __('','rapidone-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('service_more',array(
		'label'	=> __('Add read more button text.','rapidone-lite'),
		'section'	=> 'rapid_ser_sec',
		'setting'	=> 'service_more',
		'type'	=> 'text'
	));
	$wp_customize->add_setting('hide_services',array(
		'default' => true,
		'sanitize_callback' => 'rapidone_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	)); 
	$wp_customize->add_control( 'hide_services', array(
	   'settings' => 'hide_services',
	   'section'   => 'rapid_ser_sec',
	   'label'     => __('Check this to hide service section.','rapidone-lite'),
	   'type'      => 'checkbox'
    ));
	
	/******************************************************
	**	Theme First Section
	******************************************************/
	$wp_customize->add_section('rapid_wel_sec',array(
		'title' => __('Setting Up Welcome Section', 'rapidone-lite'),
		'priority' => null,
		'description'	=> __('Select page to display welcome section on homepage. This section will be displayed only when you select the static front page.','rapidone-lite'),	
	));
	$wp_customize->add_setting('welcome',array(
		'default' => '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'absint'
	));
	$wp_customize->add_control('welcome',array(
		'type'	=> 'dropdown-pages',
		'label'	=> __('Select page for display welcome section','rapidone-lite'),
		'section'	=> 'rapid_wel_sec'
	));
	$wp_customize->add_setting('welcome_more',array(
		'default'	=> __('','rapidone-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('welcome_more',array(
		'label'	=> __('Add read more button text.','rapidone-lite'),
		'section'	=> 'rapid_wel_sec',
		'setting'	=> 'welcome_more',
		'type'	=> 'text'
	));
	$wp_customize->add_setting('hide_welcome',array(
		'default' => true,
		'sanitize_callback' => 'rapidone_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	)); 
	$wp_customize->add_control( 'hide_welcome', array(
	   'settings' => 'hide_welcome',
	   'section'   => 'rapid_wel_sec',
	   'label'     => __('Check this to hide welcome section.','rapidone-lite'),
	   'type'      => 'checkbox'
    ));
}
add_action( 'customize_register', 'rapidone_lite_customize_register' );	

function rapidone_lite_css(){ ?>
	<style>
		#header,
		.sitenav ul li.menu-item-has-children:hover > ul,
		.sitenav ul li.menu-item-has-children:focus > ul,
		.sitenav ul li.menu-item-has-children.focus > ul{
			background-color:<?php echo esc_attr(get_theme_mod('rapid_headerbg-color','#ffffff')); ?>;
		}
		.nivo-directionNav a,
		h3.widget-title,
		.nav-links .current,
		.nav-links a:hover,
		p.form-submit input[type="submit"]{
			background-color:<?php echo esc_attr(get_theme_mod('rapid_color_scheme','#496068')); ?>;
		}
		a, 
		.tm_client strong,
		.postmeta a:hover,
		#sidebar ul li a:hover,
		.blog-post h3.entry-title,
		a.blog-more:hover,
		#commentform input#submit,
		input.search-submit,
		.blog-date .date{
			color:<?php echo esc_attr(get_theme_mod('rapid_color_scheme','#496068')); ?>;
		}
		.top-header-left .top-col.has-icon i,
		.top-header-right .has-social a:hover,
		.sitenav ul li.current_page_item a,
		.sitenav ul li a:hover,
		.sitenav ul li.current_page_item ul li a:hover,
		.welcome-thumb:after,
		.service-content .service-more{
			color:<?php echo esc_attr(get_theme_mod('rapid_color_sub_scheme','#ff6565')); ?>;
		}
		a.slide-button,
		.welcome-content h2:after{
			background-color:<?php echo esc_attr(get_theme_mod('rapid_color_sub_scheme','#ff6565')); ?>;
		}
		.copyright-wrapper{
			background-color:<?php echo esc_attr(get_theme_mod('rapid_footer-color','#151515')); ?>;
		}
	</style>
<?php }
add_action('wp_head','rapidone_lite_css');

function rapidone_lite_customize_preview_js() {
	wp_enqueue_script( 'rapidone-lite-customize-preview', get_template_directory_uri() . '/js/customize-preview.js', array( 'customize-preview' ), '20141216', true );
}
add_action( 'customize_preview_init', 'rapidone_lite_customize_preview_js' );