<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since RapidOne Lite 1.0
	 *
	 * @return void
	 */
	function rapidone_lite_register_block_styles() {
		// Columns: Overlap.
		register_block_style(
			'core/columns',
			array(
				'name'  => 'rapidone-lite-columns-overlap',
				'label' => esc_html__( 'Overlap', 'rapidone-lite' ),
			)
		);

		// Cover: Borders.
		register_block_style(
			'core/cover',
			array(
				'name'  => 'rapidone-lite-border',
				'label' => esc_html__( 'Borders', 'rapidone-lite' ),
			)
		);

		// Group: Borders.
		register_block_style(
			'core/group',
			array(
				'name'  => 'rapidone-lite-border',
				'label' => esc_html__( 'Borders', 'rapidone-lite' ),
			)
		);

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'rapidone-lite-border',
				'label' => esc_html__( 'Borders', 'rapidone-lite' ),
			)
		);

		// Image: Frame.
		register_block_style(
			'core/image',
			array(
				'name'  => 'rapidone-lite-image-frame',
				'label' => esc_html__( 'Frame', 'rapidone-lite' ),
			)
		);

		// Latest Posts: Dividers.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'rapidone-lite-latest-posts-dividers',
				'label' => esc_html__( 'Dividers', 'rapidone-lite' ),
			)
		);

		// Latest Posts: Borders.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'rapidone-lite-latest-posts-borders',
				'label' => esc_html__( 'Borders', 'rapidone-lite' ),
			)
		);

		// Media & Text: Borders.
		register_block_style(
			'core/media-text',
			array(
				'name'  => 'rapidone-lite-border',
				'label' => esc_html__( 'Borders', 'rapidone-lite' ),
			)
		);

		// Separator: Thick.
		register_block_style(
			'core/separator',
			array(
				'name'  => 'rapidone-lite-separator-thick',
				'label' => esc_html__( 'Thick', 'rapidone-lite' ),
			)
		);

		// Social icons: Dark gray color.
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'rapidone-lite-social-icons-color',
				'label' => esc_html__( 'Dark gray', 'rapidone-lite' ),
			)
		);
	}
	add_action( 'init', 'rapidone_lite_register_block_styles' );
}
