<?php
$section_title   = get_theme_mod( 'rapid_news_main_news_title', __( 'Main News', 'rapid-news' ) );
$main_news_query = new WP_Query( $main_news_args );
if ( $main_news_query->have_posts() ) {
	?>
	<div class="slider-part">
		<?php if ( ! empty( $section_title ) ) { ?>
			<div class="section-header">
				<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
			</div>
			<?php
		}
		?>
		<div class="banner-slider">
			<?php
			$i = 1;
			while ( $main_news_query->have_posts() ) :
				$main_news_query->the_post();
				$classes = $i === 1 ? 'grid-design' : 'list-design';

				?>
				<div class="mag-post-single banner-grid-single has-image <?php echo esc_attr( $classes ); ?>">
					<div class="mag-post-img">
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail( 'post-thumbnail' ); ?>
						</a>
					</div>
					<div class="mag-post-detail">
						<div class="mag-post-category">
							<?php rapid_news_categories_list(); ?>
						</div>
						<h3 class="mag-post-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>
						<div class="mag-post-meta">
							<?php
							rapid_news_posted_by();
							rapid_news_posted_on();
							?>
						</div>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
