<?php

function rapid_news_intro_text( $default_text ) {
	$default_text .= sprintf(
		'<div class="notice notice-info rapid-news-demo-data"><p class="demo-file-content">%1$s <a href="%2$s" target="_blank">%3$s</a></p></div>',
		esc_html__( 'Demo content files for Rapid News Theme.', 'rapid-news' ),
		esc_url( 'https://docs.ascendoor.com/docs/rapid-news/getting-started/import-demo-content/' ),
		esc_html__( 'Click here to download demo files.', 'rapid-news' )
	);
	return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'rapid_news_intro_text' );

/**
 * OCDI after import.
 */
function rapid_news_after_import_setup() {
	// Assign menus to their locations.
	$rapid_news_primary_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
	$rapid_news_social_menu  = get_term_by( 'name', 'Social Menu', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations',
		array(
			'primary' => $rapid_news_primary_menu->term_id,
			'social'  => $rapid_news_social_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$rapid_news_front_page_id = get_page_by_title( 'Home' );
	$rapid_news_blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $rapid_news_front_page_id->ID );
	update_option( 'page_for_posts', $rapid_news_blog_page_id->ID );

}
add_action( 'ocdi/after_import', 'rapid_news_after_import_setup' );
