<?php

/**
 * Typography
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_typography',
	array(
		'panel' => 'rapid_news_theme_options',
		'title' => esc_html__( 'Typography', 'rapid-news' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'rapid_news_site_title_font',
	array(
		'default'           => 'Mukta',
		'sanitize_callback' => 'rapid_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'rapid_news_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'rapid-news' ),
		'section'  => 'rapid_news_typography',
		'settings' => 'rapid_news_site_title_font',
		'type'     => 'select',
		'choices'  => rapid_news_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'rapid_news_site_description_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'rapid_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'rapid_news_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'rapid-news' ),
		'section'  => 'rapid_news_typography',
		'settings' => 'rapid_news_site_description_font',
		'type'     => 'select',
		'choices'  => rapid_news_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'rapid_news_header_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'rapid_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'rapid_news_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'rapid-news' ),
		'section'  => 'rapid_news_typography',
		'settings' => 'rapid_news_header_font',
		'type'     => 'select',
		'choices'  => rapid_news_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'rapid_news_body_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'rapid_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'rapid_news_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'rapid-news' ),
		'section'  => 'rapid_news_typography',
		'settings' => 'rapid_news_body_font',
		'type'     => 'select',
		'choices'  => rapid_news_get_all_google_font_families(),
	)
);
