<?php
/**
 * Sidebar Position
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'rapid-news' ),
		'panel' => 'rapid_news_theme_options',
	)
);

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'rapid_news_sidebar_position',
	array(
		'sanitize_callback' => 'rapid_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'rapid_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'rapid-news' ),
		'section' => 'rapid_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'rapid-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'rapid-news' ),
		),
	)
);

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'rapid_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'rapid_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'rapid_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'rapid-news' ),
		'section' => 'rapid_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'rapid-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'rapid-news' ),
		),
	)
);

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'rapid_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'rapid_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'rapid_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'rapid-news' ),
		'section' => 'rapid_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'rapid-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'rapid-news' ),
		),
	)
);
