<?php
/**
 * Post Options
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'rapid-news' ),
		'panel' => 'rapid_news_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'rapid_news_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'rapid_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'rapid-news' ),
			'section' => 'rapid_news_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'rapid_news_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'rapid_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'rapid-news' ),
			'section' => 'rapid_news_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'rapid_news_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'rapid_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'rapid-news' ),
			'section' => 'rapid_news_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'rapid_news_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'rapid_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'rapid-news' ),
			'section' => 'rapid_news_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'rapid_news_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'rapid-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'rapid_news_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'rapid-news' ),
		'section'  => 'rapid_news_post_options',
		'settings' => 'rapid_news_post_related_post_label',
		'type'     => 'text',
	)
);
