<?php
/**
 * Pagination
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_pagination',
	array(
		'panel' => 'rapid_news_theme_options',
		'title' => esc_html__( 'Pagination', 'rapid-news' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'rapid_news_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'rapid_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'rapid-news' ),
			'section'  => 'rapid_news_pagination',
			'settings' => 'rapid_news_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'rapid_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'rapid_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'rapid_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'rapid-news' ),
		'section'         => 'rapid_news_pagination',
		'settings'        => 'rapid_news_pagination_type',
		'active_callback' => 'rapid_news_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'rapid-news' ),
			'numeric' => __( 'Numeric', 'rapid-news' ),
		),
	)
);
