<?php
/**
 * Header Options
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_header_options',
	array(
		'panel' => 'rapid_news_theme_options',
		'title' => esc_html__( 'Header Options', 'rapid-news' ),
	)
);

// Header Options - Enable Topbar.
$wp_customize->add_setting(
	'rapid_news_enable_topbar',
	array(
		'sanitize_callback' => 'rapid_news_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_enable_topbar',
		array(
			'label'   => esc_html__( 'Enable Topbar', 'rapid-news' ),
			'section' => 'rapid_news_header_options',
		)
	)
);

// Header Options - Advertisement.
$wp_customize->add_setting(
	'rapid_news_header_advertisement',
	array(
		'default'           => '',
		'sanitize_callback' => 'rapid_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'rapid_news_header_advertisement',
		array(
			'label'    => esc_html__( 'Advertisement', 'rapid-news' ),
			'section'  => 'rapid_news_header_options',
			'settings' => 'rapid_news_header_advertisement',
		)
	)
);

	// Header Options - Advertisement URL.
$wp_customize->add_setting(
	'rapid_news_header_advertisement_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'rapid_news_header_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'rapid-news' ),
		'section'  => 'rapid_news_header_options',
		'settings' => 'rapid_news_header_advertisement_url',
		'type'     => 'url',
	)
);
