<?php
/**
 * Excerpt
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_excerpt_options',
	array(
		'panel' => 'rapid_news_theme_options',
		'title' => esc_html__( 'Excerpt', 'rapid-news' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'rapid_news_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'rapid_news_sanitize_number_range',
		'validate_callback' => 'rapid_news_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'rapid_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'rapid-news' ),
		'description' => esc_html__( 'Note: Min 1 & Max 200. Please input the valid number and save. Then refresh the page to see the change.', 'rapid-news' ),
		'section'     => 'rapid_news_excerpt_options',
		'settings'    => 'rapid_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 200,
			'step' => 1,
		),
	)
);
