<?php
/**
 * Breadcrumb
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'rapid-news' ),
		'panel' => 'rapid_news_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'rapid_news_enable_breadcrumb',
	array(
		'sanitize_callback' => 'rapid_news_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Rapid_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'rapid_news_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'rapid-news' ),
			'section' => 'rapid_news_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'rapid_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'rapid_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'rapid-news' ),
		'active_callback' => 'rapid_news_is_breadcrumb_enabled',
		'section'         => 'rapid_news_breadcrumb',
	)
);
