<?php
/**
 * Archive Layout
 *
 * @package Rapid News
 */

$wp_customize->add_section(
	'rapid_news_archive_layout',
	array(
		'title' => esc_html__( 'Archive Layout', 'rapid-news' ),
		'panel' => 'rapid_news_theme_options',
	)
);

// Archive Layout - Grid Style.
$wp_customize->add_setting(
	'rapid_news_archive_grid_style',
	array(
		'default'           => 'grid-column-2',
		'sanitize_callback' => 'rapid_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'rapid_news_archive_grid_style',
	array(
		'label'   => esc_html__( 'Grid Style', 'rapid-news' ),
		'section' => 'rapid_news_archive_layout',
		'type'    => 'select',
		'choices' => array(
			'grid-column-2' => __( 'Column 2', 'rapid-news' ),
			'grid-column-3' => __( 'Column 3', 'rapid-news' ),
		),
	)
);
