<?php
/**
 * Title: Kindergarten Services
 * Slug: rainbow-kindergarten/kindergarten-services
 * Categories: services
 *
 * @package rainbow-kindergarten
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"categories":["services"],"patternName":"rainbow-kindergarten/kindergarten-services","name":"Kindergarten Services"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|medium","padding":{"top":"0","bottom":"0"}},"color":{"background":"#eff5f6"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#eff5f6;margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"full"} -->
<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-bottom-cloud.png' ) ); ?>" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"style":{"spacing":{"margin":{"bottom":"0"},"padding":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group" style="margin-bottom:0;padding-top:0;padding-bottom:0"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"bottom":"0"}},"color":{"text":"#f7941d"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h2 class="wp-block-heading has-text-align-center has-text-color has-fredoka-font-family has-small-font-size" style="color:#f7941d;margin-bottom:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Educational Programs', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.3"},"color":{"text":"#af4d34"}},"fontSize":"x-large","fontFamily":"fredoka"} -->
<h2 class="wp-block-heading has-text-align-center has-text-color has-fredoka-font-family has-x-large-font-size" style="color:#af4d34;margin-bottom:var(--wp--preset--spacing--50);font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( 'Step By Step Systematic Education', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#ffca24"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#ffca24;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#ffca24"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#ffca24;font-style:normal;font-weight:600"><?php esc_html_e( '01', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Play Group', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#f169cb"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#f169cb;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#f169cb"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#f169cb;font-style:normal;font-weight:600"><?php esc_html_e( '02', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Nursery', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#19dd8d"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#19dd8d;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#19dd8d"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#19dd8d;font-style:normal;font-weight:600"><?php esc_html_e( '03', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Junior Kindergarten', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#ff5833"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#ff5833;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#ff5833"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#ff5833;font-style:normal;font-weight:600"><?php esc_html_e( '04', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Senior Kindergarten', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#f7941d"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#f7941d;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#f7941d"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#f7941d;font-style:normal;font-weight:600"><?php esc_html_e( '05', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Online Class', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"%"} -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"30px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|medium"},"color":{"background":"#af4c34"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color has-background" style="border-width:1px;border-radius:30px;background-color:#af4c34;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"100px"},"spacing":{"padding":{"top":"var:preset|spacing|xx-small","bottom":"var:preset|spacing|xx-small","left":"var:preset|spacing|xx-small","right":"var:preset|spacing|xx-small"}},"layout":{"selfStretch":"fixed","flexSize":"50px"},"color":{"background":"#f5f7fa"},"dimensions":{"minHeight":"50px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-background" style="border-radius:100px;background-color:#f5f7fa;min-height:50px;padding-top:var(--wp--preset--spacing--xx-small);padding-right:var(--wp--preset--spacing--xx-small);padding-bottom:var(--wp--preset--spacing--xx-small);padding-left:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"color":{"text":"#af4c34"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h6 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#af4c34;font-style:normal;font-weight:600"><?php esc_html_e( '06', 'rainbow-kindergarten' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":5,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium","fontFamily":"fredoka"} -->
<h5 class="wp-block-heading has-base-color has-text-color has-link-color has-fredoka-font-family has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.3"><?php esc_html_e( 'Tuition Class', 'rainbow-kindergarten' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"base","fontFamily":"fredoka"} -->
<p class="has-base-color has-text-color has-link-color has-fredoka-font-family" style="padding-top:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'We are constantly expanding the range of services offered, taking care of children.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"backgroundColor":"transparent","textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-transparent-background-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:500"><?php esc_html_e( 'Read More...', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"full"} -->
<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-top-cloud.png' ) ); ?>" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->