<?php
/**
 * Title: Kindergarten Banner
 * Slug: rainbow-kindergarten/kindergarten-banner
 * Categories: banner
 *
 * @package rainbow-kindergarten
 * @since 1.0.0
 */

?>

<!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-banner-01.jpg' ) ); ?>","dimRatio":0,"isUserOverlayColor":true,"minHeightUnit":"px","contentPosition":"center center","sizeSlug":"full","metadata":{"categories":["banner"],"patternName":"rainbow-kindergarten/kindergarten-banner","name":"Kindergarten Banner"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"0","left":"0","right":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull has-base-color has-text-color has-link-color" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-right:0;padding-bottom:0;padding-left:0"><img class="wp-block-cover__image-background size-full" alt="" src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-banner-01.jpg' ) ); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70","left":"var:preset|spacing|80"},"padding":{"bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40","top":"var:preset|spacing|40"}}}} -->
<div class="wp-block-columns" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:column {"verticalAlignment":"center","width":"55%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:55%"><!-- wp:heading {"textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"textColor":"base","fontSize":"xx-large","fontFamily":"fredoka"} -->
<h2 class="wp-block-heading has-text-align-left has-base-color has-text-color has-link-color has-fredoka-font-family has-xx-large-font-size" style="font-style:normal;font-weight:600;line-height:1.2"><?php esc_html_e( 'A Perfect Place to Explore Kids Talent', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-body"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"custom-body","fontFamily":"fredoka"} -->
<p class="has-text-align-left has-custom-body-color has-text-color has-link-color has-fredoka-font-family" style="font-style:normal;font-weight:400"><?php esc_html_e( 'We empower young learners with the confidence, creativity, compassion, and courage to thrive in a diverse and dynamic world.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"},"color":{"background":"#f7941d"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;background-color:#f7941d;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50);font-style:normal;font-weight:500"><?php esc_html_e( 'Learn More', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"45%"} -->
<div class="wp-block-column" style="flex-basis:45%"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-banner-02.png' ) ); ?>" alt="" class=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"full"} -->
<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-top-cloud.png' ) ); ?>" alt=""/></figure>
<!-- /wp:image --></div></div>
<!-- /wp:cover -->