<?php
/**
 * Title: Kindergarten About
 * Slug: rainbow-kindergarten/kindergarten-about
 * Categories: about
 *
 * @package rainbow-kindergarten
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"categories":["about"],"patternName":"rainbow-kindergarten/kindergarten-about","name":"Kindergarten About"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--60)"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"0","left":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"0"}}} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"48%","style":{"spacing":{"blockGap":"var:preset|spacing|50"}}} -->
<div class="wp-block-column" style="flex-basis:48%"><!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"left":"var:preset|spacing|medium"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-left:var(--wp--preset--spacing--medium)"><!-- wp:group {"style":{"border":{"radius":"12px","width":"0px","style":"none"},"spacing":{"blockGap":"0","padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"color":{"background":"#f7941d"}},"layout":{"type":"default"}} -->
<div class="wp-block-group has-background" style="border-style:none;border-width:0px;border-radius:12px;background-color:#f7941d;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--50)"><!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.1"},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"textColor":"base","fontSize":"x-large"} -->
<h2 class="wp-block-heading has-text-align-center has-base-color has-text-color has-link-color has-x-large-font-size" style="margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:500;line-height:1.1"><?php esc_html_e( '20', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.2","fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"medium"} -->
<p class="has-text-align-center has-base-color has-text-color has-link-color has-medium-font-size" style="font-style:normal;font-weight:500;line-height:1.2"><?php esc_html_e( 'Years Of Experience', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"center","style":{"border":{"radius":"12px"}}} -->
<figure class="wp-block-image aligncenter size-full has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-about-01.jpg' ) ); ?>" alt="" style="border-radius:12px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"52%"} -->
<div class="wp-block-column" style="flex-basis:52%"><!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--medium)"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"center","style":{"border":{"radius":"12px"}}} -->
<figure class="wp-block-image aligncenter size-full has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/kindergarten-about-02.jpg' ) ); ?>" alt="" style="border-radius:12px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"0","padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"bottom":"0"}},"color":{"text":"#f7941d"}},"fontSize":"small","fontFamily":"fredoka"} -->
<h2 class="wp-block-heading has-text-color has-fredoka-font-family has-small-font-size" style="color:#f7941d;margin-bottom:0;font-style:normal;font-weight:500"><?php esc_html_e( 'About Us', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.3"},"color":{"text":"#af4d34"}},"fontSize":"x-large","fontFamily":"fredoka"} -->
<h2 class="wp-block-heading has-text-color has-fredoka-font-family has-x-large-font-size" style="color:#af4d34;margin-bottom:0;font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( 'We Educate Knowledge & Essential Skills!', 'rainbow-kindergarten' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontFamily":"fredoka"} -->
<p class="has-fredoka-font-family" style="margin-bottom:var(--wp--preset--spacing--50);font-style:normal;font-weight:400"><?php esc_html_e( 'In our kindergarten, every child is a star twinkling in the vast expanse of the universe, each one unique and precious in their own right.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|small"}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontFamily":"fredoka"} -->
<p class="has-fredoka-font-family" style="margin-bottom:var(--wp--preset--spacing--small);font-style:normal;font-weight:400"><?php esc_html_e( 'We believe in nurturing not just the mind, but the soul, guiding each little explorer on a journey of self-discovery and wonder. Welcome to a world where dreams take flight and hearts soar high above the clouds.', 'rainbow-kindergarten' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:button {"textColor":"base","className":"is-style-rainbow-kindergarten-flat-button is-style-fill","style":{"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"5px"},"typography":{"fontStyle":"normal","fontWeight":"500"},"color":{"background":"#f7941d"}},"fontFamily":"fredoka"} -->
<div class="wp-block-button is-style-rainbow-kindergarten-flat-button is-style-fill"><a class="wp-block-button__link has-base-color has-text-color has-background has-link-color has-fredoka-font-family wp-element-button" href="#" style="border-radius:5px;background-color:#f7941d;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50);font-style:normal;font-weight:500"><?php esc_html_e( 'Read More', 'rainbow-kindergarten' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->